/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form;

import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.HierarchicalFormModel;
import org.springframework.binding.value.ValueModel;
import org.springframework.richclient.application.config.ApplicationObjectConfigurer;
import org.springframework.richclient.components.Focussable;
import org.springframework.richclient.util.RcpSupport;
import org.springframework.richclient.widget.AbstractWidgetForm;

public abstract class AbstractFocussableForm
extends AbstractWidgetForm
implements Focussable {
    public static final String UNSAVEDCHANGES_WARNING_ID = "unsavedchanges.warning";
    public static final String UNSAVEDCHANGES_HASERRORS_WARNING_ID = "unsavedchanges.haserrors.warning";
    private JComponent focusControl;
    private final Runnable focusRequestRunnable = new Runnable(){

        public void run() {
            if (AbstractFocussableForm.this.focusControl != null) {
                AbstractFocussableForm.this.focusControl.requestFocusInWindow();
            }
        }
    };

    protected void handleEnabledChange(boolean enabled) {
    }

    public void setFocusControl(JComponent field) {
        this.focusControl = field;
    }

    public void grabFocus() {
        if (this.focusControl != null) {
            EventQueue.invokeLater(this.focusRequestRunnable);
        }
    }

    public AbstractFocussableForm() {
    }

    public AbstractFocussableForm(FormModel formModel, String formId) {
        super(formModel, formId);
    }

    public AbstractFocussableForm(FormModel pageFormModel) {
        super(pageFormModel);
    }

    public AbstractFocussableForm(HierarchicalFormModel parentFormModel, String formId, String childFormObjectPropertyPath) {
        super(parentFormModel, formId, childFormObjectPropertyPath);
    }

    public AbstractFocussableForm(HierarchicalFormModel parentFormModel, String formId, ValueModel childFormObjectHolder) {
        super(parentFormModel, formId, childFormObjectHolder);
    }

    public AbstractFocussableForm(HierarchicalFormModel parentFormModel, String formId) {
        super(parentFormModel, formId);
    }

    public AbstractFocussableForm(Object formObject) {
        super(formObject);
    }

    public AbstractFocussableForm(String formId) {
        super(formId);
    }

    public boolean canClose() {
        boolean userBreak = false;
        int answer = 1;
        if (this.getFormModel().isEnabled() && this.getFormModel().isDirty() && this.getCommitCommand().isAuthorized()) {
            answer = RcpSupport.showWarningDialog((Component)this.getControl(), UNSAVEDCHANGES_WARNING_ID, 1);
            switch (answer) {
                case 2: {
                    userBreak = true;
                    break;
                }
                case 0: {
                    if (this.getFormModel().getHasErrors()) {
                        RcpSupport.showWarningDialog(this.getControl(), UNSAVEDCHANGES_HASERRORS_WARNING_ID);
                        userBreak = true;
                        break;
                    }
                    this.getCommitCommand().execute();
                    break;
                }
                case 1: {
                    this.revert();
                }
            }
        }
        return !userBreak;
    }

    protected void init() {
        ((ApplicationObjectConfigurer)this.getApplicationServices().getService(ApplicationObjectConfigurer.class)).configure(this, this.getId());
    }
}

