/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.binding.form.ValidatingFormModel;
import org.springframework.richclient.core.Guarded;

public class FormGuard
implements PropertyChangeListener {
    public static final int ON_NOERRORS = 1;
    public static final int ON_ISDIRTY = 2;
    public static final int ON_ENABLED = 4;
    public static final int LIKE_NEWFORMOBJCOMMAND = 4;
    public static final int LIKE_REVERTCOMMAND = 6;
    public static final int LIKE_COMMITCOMMAND = 7;
    public static final int FORMERROR_GUARDED = 5;
    private final ValidatingFormModel formModel;
    private final Map guardedEntries = Collections.synchronizedMap(new HashMap());

    public FormGuard(ValidatingFormModel formModel) {
        this.formModel = formModel;
        this.formModel.addPropertyChangeListener("enabled", this);
        this.formModel.addPropertyChangeListener("hasErrors", this);
        this.formModel.addPropertyChangeListener("dirty", this);
    }

    public FormGuard(ValidatingFormModel formModel, Guarded guarded) {
        this(formModel, guarded, 5);
    }

    public FormGuard(ValidatingFormModel formModel, Guarded guarded, int mask) {
        this(formModel);
        this.addGuarded(guarded, mask);
    }

    private void updateAllGuarded() {
        int formState = this.getFormModelState();
        for (Guarded guarded : this.guardedEntries.keySet()) {
            int mask = (Integer)this.guardedEntries.get(guarded);
            boolean b = this.stateMatchesMask(formState, mask);
            guarded.setEnabled(b);
        }
    }

    private boolean stateMatchesMask(int formState, int mask) {
        return (mask & formState) == mask;
    }

    private int getFormModelState() {
        int formState = 0;
        if (!this.formModel.getHasErrors()) {
            ++formState;
        }
        if (this.formModel.isDirty()) {
            formState += 2;
        }
        if (this.formModel.isEnabled()) {
            formState += 4;
        }
        return formState;
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.updateAllGuarded();
    }

    public void addGuarded(Guarded newGuarded, int mask) {
        this.guardedEntries.put(newGuarded, new Integer(mask));
        newGuarded.setEnabled(this.stateMatchesMask(this.getFormModelState(), mask));
    }

    public boolean removeGuarded(Guarded toRemove) {
        Object mask = this.guardedEntries.remove(toRemove);
        return mask != null;
    }
}

