/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.application.support.ApplicationServicesAccessor;
import org.springframework.richclient.form.binding.Binder;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.util.Assert;

public abstract class AbstractBinder
extends ApplicationServicesAccessor
implements Binder {
    public static final String BINDING_CLIENT_PROPERTY_KEY = "binding";
    protected final Log log = LogFactory.getLog(this.getClass());
    private final Class requiredSourceClass;
    private final Set supportedContextKeys;

    protected AbstractBinder(Class requiredSourceClass) {
        this.requiredSourceClass = requiredSourceClass;
        this.supportedContextKeys = Collections.EMPTY_SET;
    }

    protected AbstractBinder(Class requiredSourceClass, String[] supportedContextKeys) {
        this.requiredSourceClass = requiredSourceClass;
        this.supportedContextKeys = new HashSet<String>(Arrays.asList(supportedContextKeys));
    }

    protected void validateContextKeys(Map context) {
        HashSet unkownKeys = new HashSet(context.keySet());
        unkownKeys.removeAll(this.supportedContextKeys);
        for (Object key : unkownKeys) {
            context.remove(key);
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn((Object)("Context key '" + key + "' not supported."));
        }
    }

    public Class getRequiredSourceClass() {
        return this.requiredSourceClass;
    }

    public Binding bind(FormModel formModel, String formPropertyPath, Map context) {
        JComponent control = this.createControl(context);
        Assert.notNull((Object)control, (String)"This binder does not support creating a default control.");
        return this.bind(control, formModel, formPropertyPath, context);
    }

    protected abstract JComponent createControl(Map var1);

    public Binding bind(JComponent control, FormModel formModel, String formPropertyPath, Map context) {
        Binding binding = (Binding)control.getClientProperty(BINDING_CLIENT_PROPERTY_KEY);
        if (binding != null) {
            throw new IllegalStateException("Component is already bound to property: " + binding.getProperty());
        }
        this.validateContextKeys(context);
        binding = this.doBind(control, formModel, formPropertyPath, context);
        control.putClientProperty(BINDING_CLIENT_PROPERTY_KEY, binding);
        return binding;
    }

    protected abstract Binding doBind(JComponent var1, FormModel var2, String var3, Map var4);

    protected Class getPropertyType(FormModel formModel, String formPropertyPath) {
        return formModel.getFieldMetadata(formPropertyPath).getPropertyType();
    }
}

