/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.form.binding.Binder;
import org.springframework.richclient.form.binding.BinderSelectionStrategy;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.BindingFactory;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.util.Assert;

public abstract class AbstractBindingFactory
implements BindingFactory {
    private BinderSelectionStrategy binderSelectionStrategy;
    private FormModel formModel;
    private FormComponentInterceptor interceptor;

    protected AbstractBindingFactory(FormModel formModel) {
        Assert.notNull((Object)formModel, (String)"formModel can not be null.");
        this.formModel = formModel;
        FormComponentInterceptorFactory factory = (FormComponentInterceptorFactory)ApplicationServicesLocator.services().getService(FormComponentInterceptorFactory.class);
        this.interceptor = factory.getInterceptor(formModel);
    }

    public Binding createBinding(String formPropertyPath) {
        return this.createBinding(formPropertyPath, Collections.EMPTY_MAP);
    }

    public Binding createBinding(Class controlType, String formPropertyPath) {
        return this.createBinding(controlType, formPropertyPath, Collections.EMPTY_MAP);
    }

    public Binding bindControl(JComponent control, String formPropertyPath) {
        return this.bindControl(control, formPropertyPath, Collections.EMPTY_MAP);
    }

    public Binding createBinding(String formPropertyPath, Map context) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        Binder binder = this.getBinderSelectionStrategy().selectBinder(this.formModel, formPropertyPath);
        Binding binding = binder.bind(this.formModel, formPropertyPath, context);
        this.interceptBinding(binding);
        return binding;
    }

    public Binding createBinding(Class controlType, String formPropertyPath, Map context) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        Binder binder = this.getBinderSelectionStrategy().selectBinder(controlType, this.formModel, formPropertyPath);
        Binding binding = binder.bind(this.formModel, formPropertyPath, context);
        this.interceptBinding(binding);
        return binding;
    }

    public Binding bindControl(JComponent control, String formPropertyPath, Map context) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        Binder binder = this.getBinderSelectionStrategy().selectBinder(control.getClass(), this.formModel, formPropertyPath);
        Binding binding = binder.bind(control, this.formModel, formPropertyPath, context);
        this.interceptBinding(binding);
        return binding;
    }

    public void interceptBinding(Binding binding) {
        if (this.interceptor != null) {
            this.interceptor.processComponent(binding.getProperty(), binding.getControl());
        }
    }

    public FormModel getFormModel() {
        return this.formModel;
    }

    protected BinderSelectionStrategy getBinderSelectionStrategy() {
        if (this.binderSelectionStrategy == null) {
            this.binderSelectionStrategy = (BinderSelectionStrategy)ApplicationServicesLocator.services().getService(BinderSelectionStrategy.class);
        }
        return this.binderSelectionStrategy;
    }

    public void setBinderSelectionStrategy(BinderSelectionStrategy binderSelectionStrategy) {
        this.binderSelectionStrategy = binderSelectionStrategy;
    }

    protected Map createContext(String key, Object value) {
        HashMap<String, Object> context = new HashMap<String, Object>(4);
        context.put(key, value);
        return context;
    }
}

