/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.support;

import java.util.ArrayList;
import java.util.List;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.form.binding.support.CustomBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCRUDBinding
extends CustomBinding {
    private AbstractCommand removeCommand;
    private AbstractCommand addCommand;
    private AbstractCommand detailCommand;
    private AbstractCommand editCommand;
    private List<AbstractCommand> commands;
    private boolean addSupported;
    private boolean removeSupported;
    private boolean editSupported;
    private boolean showDetailSupported;

    protected AbstractCRUDBinding(FormModel formModel, String formPropertyPath, Class requiredSourceClass) {
        super(formModel, formPropertyPath, requiredSourceClass);
    }

    protected List<AbstractCommand> getCommands() {
        if (this.commands == null) {
            this.commands = this.createCommands();
        }
        return this.commands;
    }

    protected List<AbstractCommand> createCommands() {
        int i = this.isAddSupported() ? 1 : 0;
        i = this.isRemoveSupported() ? i + 1 : i;
        i = this.isShowDetailSupported() ? i + 1 : i;
        i = this.isEditSupported() ? i + 1 : i;
        this.commands = new ArrayList<AbstractCommand>(i);
        if (this.isShowDetailSupported()) {
            this.commands.add(this.getDetailCommand());
        }
        if (this.isAddSupported()) {
            this.commands.add(this.getAddCommand());
        }
        if (this.isRemoveSupported()) {
            this.commands.add(this.getRemoveCommand());
        }
        if (this.isEditSupported()) {
            this.commands.add(this.getEditCommand());
        }
        return this.commands;
    }

    protected AbstractCommand getAddCommand() {
        if (this.addCommand == null) {
            this.addCommand = this.createAddCommand();
        }
        return this.addCommand;
    }

    protected abstract AbstractCommand createAddCommand();

    protected AbstractCommand getRemoveCommand() {
        if (this.removeCommand == null) {
            this.removeCommand = this.createRemoveCommand();
        }
        return this.removeCommand;
    }

    protected abstract AbstractCommand createRemoveCommand();

    protected AbstractCommand getDetailCommand() {
        if (this.detailCommand == null) {
            this.detailCommand = this.createDetailCommand();
        }
        return this.detailCommand;
    }

    protected abstract AbstractCommand createDetailCommand();

    protected AbstractCommand getEditCommand() {
        if (this.editCommand == null) {
            this.editCommand = this.createEditCommand();
        }
        return this.editCommand;
    }

    protected abstract AbstractCommand createEditCommand();

    public boolean isAddSupported() {
        return this.addSupported;
    }

    public void setAddSupported(boolean addSupported) {
        this.addSupported = addSupported;
    }

    public boolean isEditSupported() {
        return this.editSupported;
    }

    public void setEditSupported(boolean editSupported) {
        this.editSupported = editSupported;
    }

    public boolean isRemoveSupported() {
        return this.removeSupported;
    }

    public void setRemoveSupported(boolean removeSupported) {
        this.removeSupported = removeSupported;
    }

    public boolean isShowDetailSupported() {
        return this.showDetailSupported;
    }

    public void setShowDetailSupported(boolean showDetailSupported) {
        this.showDetailSupported = showDetailSupported;
    }
}

