/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.swing.AbstractListBinding;
import org.springframework.richclient.list.AbstractFilteredListModel;

public class ComboBoxBinding
extends AbstractListBinding {
    private Object emptySelectionValue;
    private BoundComboBoxModel boundModel;

    public ComboBoxBinding(FormModel formModel, String formPropertyPath) {
        this(new JComboBox(), formModel, formPropertyPath, null);
    }

    public ComboBoxBinding(JComboBox comboBox, FormModel formModel, String formPropertyPath) {
        this(comboBox, formModel, formPropertyPath, null);
    }

    public ComboBoxBinding(JComboBox comboBox, FormModel formModel, String formPropertyPath, Class requiredSourceClass) {
        super(comboBox, formModel, formPropertyPath, requiredSourceClass);
    }

    protected void doBindControl(ListModel bindingModel) {
        this.boundModel = new BoundComboBoxModel(bindingModel);
        this.getComboBox().setModel(this.boundModel);
    }

    protected ListModel getDefaultModel() {
        return this.getComboBox().getModel();
    }

    public ListCellRenderer getRenderer() {
        return this.getComboBox().getRenderer();
    }

    public JComboBox getComboBox() {
        return (JComboBox)this.getComponent();
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.getComboBox().setRenderer(renderer);
    }

    public void setEditor(ComboBoxEditor comboBoxEditor) {
        this.getComboBox().setEditor(comboBoxEditor);
    }

    public ComboBoxEditor getEditor() {
        return this.getComboBox().getEditor();
    }

    public void setEmptySelectionValue(Object value) {
        if (value != this.emptySelectionValue && this.boundModel != null) {
            this.emptySelectionValue = value;
            this.boundModel.emptySelectionValueChanged();
        } else {
            this.emptySelectionValue = value;
        }
    }

    public Object getEmptySelectionValue() {
        return this.emptySelectionValue;
    }

    private class BoundComboBoxModel
    extends AbstractFilteredListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        public BoundComboBoxModel(ListModel listModel) {
            super(listModel);
            ComboBoxBinding.this.getValueModel().addValueChangeListener(this);
        }

        public int getSize() {
            if (ComboBoxBinding.this.emptySelectionValue != null) {
                return super.getSize() + 1;
            }
            return super.getSize();
        }

        public Object getElementAt(int index) {
            if (ComboBoxBinding.this.emptySelectionValue != null) {
                if (index == 0) {
                    return ComboBoxBinding.this.emptySelectionValue;
                }
                return super.getElementAt(index - 1);
            }
            return super.getElementAt(index);
        }

        private boolean updateSelectedItem() {
            Object selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                boolean found = false;
                int size = this.getSize();
                for (int i = 0; i < size && !found; ++i) {
                    found = selectedItem.equals(this.getElementAt(i));
                }
                if (!found) {
                    this.setSelectedItem(null);
                    return true;
                }
            }
            return false;
        }

        public void contentsChanged(ListDataEvent e) {
            if (this.updateSelectedItem()) {
                this.fireContentsChanged(this, -1, -1);
            } else {
                super.contentsChanged(e);
            }
        }

        public void intervalRemoved(ListDataEvent e) {
            if (this.updateSelectedItem()) {
                this.fireContentsChanged(this, -1, -1);
            } else {
                super.intervalRemoved(e);
            }
        }

        public void setSelectedItem(Object selectedItem) {
            if (selectedItem == ComboBoxBinding.this.emptySelectionValue) {
                selectedItem = null;
            }
            ComboBoxBinding.this.getValueModel().setValueSilently(selectedItem, this);
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            Object value = ComboBoxBinding.this.getValue();
            if (ComboBoxBinding.this.emptySelectionValue != null && value == null) {
                return ComboBoxBinding.this.emptySelectionValue;
            }
            return value;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.fireContentsChanged(this, -1, -1);
        }

        public void emptySelectionValueChanged() {
            this.fireContentsChanged(this, -1, -1);
        }
    }
}

