/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.richclient.form.binding.swing.AbstractListBinding;
import org.springframework.richclient.form.binding.swing.ComboBoxBinder;
import org.springframework.richclient.form.binding.swing.ComboBoxBinding;
import org.springframework.richclient.list.TextValueListRenderer;
import org.springframework.util.Assert;

public class EnumComboBoxBinder
extends ComboBoxBinder {
    protected AbstractListBinding createListBinding(JComponent control, FormModel formModel, String formPropertyPath) {
        ComboBoxBinding binding = (ComboBoxBinding)super.createListBinding(control, formModel, formPropertyPath);
        binding.setSelectableItems(this.createEnumSelectableItems(formModel, formPropertyPath));
        MessageSourceAccessor messageSourceAccessor = this.getMessages();
        binding.setRenderer(new EnumListRenderer(messageSourceAccessor));
        binding.setEditor(new EnumComboBoxEditor(messageSourceAccessor, binding.getEditor()));
        return binding;
    }

    protected Enum[] createEnumSelectableItems(FormModel formModel, String formPropertyPath) {
        Class propertyType;
        Class enumPropertyType = propertyType = this.getPropertyType(formModel, formPropertyPath);
        return (Enum[])enumPropertyType.getEnumConstants();
    }

    public class EnumComboBoxEditor
    implements ComboBoxEditor {
        private Object current;
        private MessageSourceAccessor messageSourceAccessor;
        private ComboBoxEditor inner;

        public EnumComboBoxEditor(MessageSourceAccessor messageSourceAccessor, ComboBoxEditor editor) {
            Assert.notNull((Object)editor, (String)"Editor cannot be null");
            this.inner = editor;
            this.messageSourceAccessor = messageSourceAccessor;
        }

        public void selectAll() {
            this.inner.selectAll();
        }

        public Component getEditorComponent() {
            return this.inner.getEditorComponent();
        }

        public void addActionListener(ActionListener l) {
            this.inner.addActionListener(l);
        }

        public void removeActionListener(ActionListener l) {
            this.inner.removeActionListener(l);
        }

        public Object getItem() {
            return this.current;
        }

        public void setItem(Object value) {
            this.current = value;
            if (value != null) {
                Enum valueEnum = (Enum)value;
                Class<?> valueClass = valueEnum.getClass();
                this.inner.setItem(this.messageSourceAccessor.getMessage(valueClass.getName() + "." + valueEnum.name()));
            } else {
                this.inner.setItem(null);
            }
        }
    }

    public class EnumListRenderer
    extends TextValueListRenderer {
        private MessageSourceAccessor messageSourceAccessor;

        public EnumListRenderer(MessageSourceAccessor messageSourceAccessor) {
            this.messageSourceAccessor = messageSourceAccessor;
        }

        protected String getTextValue(Object value) {
            if (value == null) {
                return "";
            }
            Enum valueEnum = (Enum)value;
            Class<?> valueClass = valueEnum.getClass();
            return this.messageSourceAccessor.getMessage(valueClass.getName() + "." + valueEnum.name());
        }
    }
}

