/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.io.File;
import java.util.Map;
import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.components.FileChooser;
import org.springframework.richclient.form.binding.Binder;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.swing.FileChooserBinding;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChooserBinder
implements Binder {
    public static final String BINDING_CLIENT_PROPERTY_KEY = "binding";
    private boolean useFile = false;
    private FileChooser.FileChooserMode mode = FileChooser.FileChooserMode.FILE;

    protected JComponent createControl(Map context) {
        return new FileChooser();
    }

    protected Binding doBind(JComponent control, FormModel formModel, String formPropertyPath, Map context) {
        FileChooser chooser = (FileChooser)control;
        if (this.useFile) {
            return new FileChooserBinding(formModel, formPropertyPath, File.class, chooser, this.mode, this.useFile);
        }
        return new FileChooserBinding(formModel, formPropertyPath, String.class, chooser, this.mode, this.useFile);
    }

    @Override
    public Binding bind(FormModel formModel, String formPropertyPath, Map context) {
        JComponent control = this.createControl(context);
        Assert.notNull((Object)control, (String)"This binder does not support creating a default control.");
        return this.bind(control, formModel, formPropertyPath, context);
    }

    @Override
    public Binding bind(JComponent control, FormModel formModel, String formPropertyPath, Map context) {
        Binding binding = (Binding)control.getClientProperty(BINDING_CLIENT_PROPERTY_KEY);
        if (binding != null) {
            throw new IllegalStateException("Component is already bound to property: " + binding.getProperty());
        }
        binding = this.doBind(control, formModel, formPropertyPath, context);
        control.putClientProperty(BINDING_CLIENT_PROPERTY_KEY, binding);
        return binding;
    }

    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public void setMode(FileChooser.FileChooserMode mode) {
        this.mode = mode;
    }

    public FileChooser.FileChooserMode getMode() {
        return this.mode;
    }

    protected Class<?> getPropertyType(FormModel formModel, String formPropertyPath) {
        return formModel.getFieldMetadata(formPropertyPath).getPropertyType();
    }
}

