/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.value.ValueModel;
import org.springframework.richclient.components.ShuttleList;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.support.AbstractBinder;
import org.springframework.richclient.form.binding.swing.ShuttleListBinding;
import org.springframework.richclient.list.BeanPropertyValueListRenderer;
import org.springframework.util.Assert;

public class ShuttleListBinder
extends AbstractBinder {
    public static final String SELECTABLE_ITEMS_HOLDER_KEY = "selectableItemsHolder";
    public static final String SELECTED_ITEMS_HOLDER_KEY = "selectedItemHolder";
    public static final String SELECTED_ITEM_TYPE_KEY = "selectedItemType";
    public static final String MODEL_KEY = "model";
    public static final String FORM_ID = "formId";
    public static final String COMPARATOR_KEY = "comparator";
    public static final String RENDERER_KEY = "renderer";
    private boolean showEditButton = true;

    public void setShowEditButton(boolean showEditButton) {
        this.showEditButton = showEditButton;
    }

    public static Map createBindingContext(FormModel formModel, String selectionFormProperty, ValueModel selectableItemsHolder, String renderedProperty) {
        HashMap<String, Object> context = new HashMap<String, Object>(4);
        context.put(FORM_ID, formModel.getId());
        ValueModel selectionValueModel = formModel.getValueModel(selectionFormProperty);
        context.put(SELECTED_ITEMS_HOLDER_KEY, selectionValueModel);
        Class selectionPropertyType = formModel.getFieldMetadata(selectionFormProperty).getPropertyType();
        if (selectionPropertyType != null) {
            context.put(SELECTED_ITEM_TYPE_KEY, selectionPropertyType);
        }
        context.put(SELECTABLE_ITEMS_HOLDER_KEY, selectableItemsHolder);
        if (renderedProperty != null) {
            context.put(RENDERER_KEY, new BeanPropertyValueListRenderer(renderedProperty));
            context.put(COMPARATOR_KEY, new PropertyComparator(renderedProperty, true, true));
        }
        return context;
    }

    public ShuttleListBinder() {
        super(null, new String[]{SELECTABLE_ITEMS_HOLDER_KEY, SELECTED_ITEMS_HOLDER_KEY, SELECTED_ITEM_TYPE_KEY, MODEL_KEY, COMPARATOR_KEY, RENDERER_KEY, FORM_ID});
    }

    protected ShuttleListBinder(String[] supportedContextKeys) {
        super(null, supportedContextKeys);
    }

    protected Binding doBind(JComponent control, FormModel formModel, String formPropertyPath, Map context) {
        Assert.isTrue((boolean)(control instanceof ShuttleList), (String)formPropertyPath);
        ShuttleListBinding binding = new ShuttleListBinding((ShuttleList)control, formModel, formPropertyPath);
        this.applyContext(binding, context);
        return binding;
    }

    protected void applyContext(ShuttleListBinding binding, Map context) {
        if (context.containsKey(MODEL_KEY)) {
            binding.setModel((ListModel)context.get(MODEL_KEY));
        }
        if (context.containsKey(SELECTABLE_ITEMS_HOLDER_KEY)) {
            binding.setSelectableItemsHolder((ValueModel)context.get(SELECTABLE_ITEMS_HOLDER_KEY));
        }
        if (context.containsKey(SELECTED_ITEMS_HOLDER_KEY)) {
            binding.setSelectedItemsHolder((ValueModel)context.get(SELECTED_ITEMS_HOLDER_KEY));
        }
        if (context.containsKey(RENDERER_KEY)) {
            binding.setRenderer((ListCellRenderer)context.get(RENDERER_KEY));
        }
        if (context.containsKey(COMPARATOR_KEY)) {
            binding.setComparator((Comparator)context.get(COMPARATOR_KEY));
        }
        if (context.containsKey(SELECTED_ITEM_TYPE_KEY)) {
            binding.setSelectedItemType((Class)context.get(SELECTED_ITEM_TYPE_KEY));
        }
        if (context.containsKey(FORM_ID)) {
            binding.setFormId((String)context.get(FORM_ID));
        }
    }

    protected JComponent createControl(Map context) {
        ShuttleList shuttleList = new ShuttleList(this.showEditButton);
        return shuttleList;
    }
}

