/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.richclient.form.binding.Binder;
import org.springframework.richclient.form.binding.support.AbstractBinderSelectionStrategy;
import org.springframework.richclient.form.binding.swing.CheckBoxBinder;
import org.springframework.richclient.form.binding.swing.ComboBoxBinder;
import org.springframework.richclient.form.binding.swing.FormattedTextFieldBinder;
import org.springframework.richclient.form.binding.swing.LabelBinder;
import org.springframework.richclient.form.binding.swing.LabeledEnumComboBoxBinder;
import org.springframework.richclient.form.binding.swing.ListBinder;
import org.springframework.richclient.form.binding.swing.ScrollPaneBinder;
import org.springframework.richclient.form.binding.swing.TextAreaBinder;
import org.springframework.richclient.form.binding.swing.TextComponentBinder;
import org.springframework.richclient.form.binding.swing.ToggleButtonBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingBinderSelectionStrategy
extends AbstractBinderSelectionStrategy {
    private Map<String, Binder> idBoundBinders = new HashMap<String, Binder>();

    public SwingBinderSelectionStrategy() {
        super(JTextField.class);
    }

    public void setIdBoundBinders(Map binders) {
        this.idBoundBinders = binders;
    }

    public void registerIdBoundBinders(Map<String, Binder> binders) {
        this.idBoundBinders.putAll(binders);
    }

    public Binder getIdBoundBinder(String id) {
        Binder binder = this.idBoundBinders.get(id);
        if (binder == null) {
            Object binderBean = this.getApplicationContext().getBean(id);
            if (binderBean instanceof Binder) {
                if (binderBean != null) {
                    this.idBoundBinders.put(id, (Binder)binderBean);
                    binder = (Binder)binderBean;
                }
            } else {
                throw new IllegalArgumentException("Bean '" + id + "' was found, but was not a binder");
            }
        }
        return binder;
    }

    public Binder selectBinder(Class controlType) {
        return this.findBinderByControlType(controlType);
    }

    @Override
    protected void registerDefaultBinders() {
        this.registerBinderForPropertyType(String.class, new TextComponentBinder());
        this.registerBinderForPropertyType(Boolean.TYPE, new CheckBoxBinder());
        this.registerBinderForPropertyType(Boolean.class, new CheckBoxBinder());
        this.registerBinderForPropertyType(LabeledEnum.class, new LabeledEnumComboBoxBinder());
        this.registerBinderForControlType(JTextComponent.class, new TextComponentBinder());
        this.registerBinderForControlType(JFormattedTextField.class, new FormattedTextFieldBinder(null));
        this.registerBinderForControlType(JTextArea.class, new TextAreaBinder());
        this.registerBinderForControlType(JToggleButton.class, new ToggleButtonBinder());
        this.registerBinderForControlType(JCheckBox.class, new CheckBoxBinder());
        this.registerBinderForControlType(JComboBox.class, new ComboBoxBinder());
        this.registerBinderForControlType(JList.class, new ListBinder());
        this.registerBinderForControlType(JLabel.class, new LabelBinder());
        this.registerBinderForControlType(JScrollPane.class, new ScrollPaneBinder(this, JTextArea.class));
    }
}

