/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.util.Map;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.support.AbstractBinder;
import org.springframework.richclient.form.binding.swing.TextComponentBinding;
import org.springframework.richclient.form.binding.swing.text.DocumentFactory;
import org.springframework.util.Assert;

public class TextComponentBinder
extends AbstractBinder {
    private String promptKey;
    private boolean convertEmptyStringToNull;
    private DocumentFactory documentFactory;
    private boolean readOnly;
    private boolean selectAllOnFocus;

    public TextComponentBinder() {
        super(String.class);
    }

    protected Binding doBind(JComponent control, FormModel formModel, String formPropertyPath, Map context) {
        Assert.isTrue((boolean)(control instanceof JTextComponent), (String)"Control must be an instance of JTextComponent.");
        TextComponentBinding textComponentBinding = new TextComponentBinding((JTextComponent)control, formModel, formPropertyPath);
        textComponentBinding.setConvertEmptyStringToNull(this.convertEmptyStringToNull);
        textComponentBinding.setPromptKey(this.promptKey);
        textComponentBinding.setReadOnly(this.readOnly);
        textComponentBinding.setSelectAllOnFocus(this.selectAllOnFocus);
        return textComponentBinding;
    }

    protected JTextComponent createTextComponent() {
        return this.getComponentFactory().createTextField();
    }

    protected JComponent createControl(Map context) {
        JTextComponent textComponent = this.createTextComponent();
        if (this.getDocumentFactory() != null) {
            textComponent.setDocument(this.getDocumentFactory().createDocument());
        }
        return textComponent;
    }

    public boolean isConvertEmptyStringToNull() {
        return this.convertEmptyStringToNull;
    }

    public void setConvertEmptyStringToNull(boolean convertEmptyStringToNull) {
        this.convertEmptyStringToNull = convertEmptyStringToNull;
    }

    public String getPromptKey() {
        return this.promptKey;
    }

    public void setPromptKey(String promptKey) {
        this.promptKey = promptKey;
    }

    public DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.selectAllOnFocus = selectAllOnFocus;
    }
}

