/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jdesktop.xswingx.PromptSupport;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.swing.AsYouTypeTextComponentAdapter;
import org.springframework.richclient.form.binding.support.AbstractBinding;
import org.springframework.richclient.text.SelectAllFocusListener;
import org.springframework.richclient.util.RcpSupport;

public class TextComponentBinding
extends AbstractBinding {
    private final JTextComponent textComponent;
    private boolean convertEmptyStringToNull;
    private String promptKey;
    private boolean readOnly;
    private boolean selectAllOnFocus;

    public TextComponentBinding(JTextComponent textComponent, FormModel formModel, String formPropertyPath) {
        super(formModel, formPropertyPath, String.class);
        this.textComponent = textComponent;
    }

    protected JComponent doBindControl() {
        ValueModel valueModel = this.getValueModel();
        try {
            this.textComponent.setText((String)valueModel.getValue());
        }
        catch (ClassCastException e) {
            IllegalArgumentException ex = new IllegalArgumentException("Class cast exception converting '" + this.getProperty() + "' property value to string - did you install a type converter?");
            ex.initCause(e);
            throw ex;
        }
        if (this.getPromptKey() != null) {
            PromptSupport.setPrompt((String)RcpSupport.getMessage(this.getPromptKey()), (JTextComponent)this.textComponent);
        }
        new AsYouTypeTextComponentAdapter(this.textComponent, valueModel, this.convertEmptyStringToNull);
        if (this.selectAllOnFocus) {
            this.textComponent.addFocusListener(new SelectAllFocusListener(this.textComponent));
        }
        return this.textComponent;
    }

    public boolean isReadOnly() {
        return super.isReadOnly() || this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    protected void readOnlyChanged() {
        this.textComponent.setEditable(!this.isReadOnly());
    }

    protected void enabledChanged() {
        this.textComponent.setEnabled(this.isEnabled());
    }

    public String getPromptKey() {
        return this.promptKey;
    }

    public void setPromptKey(String promptKey) {
        this.promptKey = promptKey;
    }

    public boolean isConvertEmptyStringToNull() {
        return this.convertEmptyStringToNull;
    }

    public void setConvertEmptyStringToNull(boolean convertEmptyStringToNull) {
        this.convertEmptyStringToNull = convertEmptyStringToNull;
    }

    public boolean isSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.selectAllOnFocus = selectAllOnFocus;
    }
}

