/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing.date;

import java.awt.Dimension;
import java.util.Map;
import javax.swing.JComponent;
import net.sf.nachocalendar.components.DateField;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.swing.date.AbstractDateFieldBinder;
import org.springframework.richclient.form.binding.swing.date.NachoCalendarDateFieldBinding;
import org.springframework.util.Assert;

public class NachoCalendarDateFieldBinder
extends AbstractDateFieldBinder {
    public static final String ALLOWS_INVALID_KEY = "allowsInvalid";
    public static final String ANTI_ALIASED_KEY = "antiAliased";
    public static final String FIRST_DAY_OF_WEEK_KEY = "firstDayOfWeek";
    public static final String HEADER_RENDERER_KEY = "headerRenderer";
    public static final String MODEL_KEY = "model";
    public static final String PRINT_MOON_KEY = "printMoon";
    public static final String RENDERER_KEY = "renderer";
    public static final String SHOW_OK_CANCEL_KEY = "showOkCancel";
    public static final String SHOW_TODAY_KEY = "showToday";
    public static final String TODAY_CAPTION_KEY = "todayCaption";
    public static final String WORKING_DAYS_KEY = "workingDays";
    public static final String SHOW_WEEKNUMBERS_KEY = "showWeekNumbers";

    public NachoCalendarDateFieldBinder() {
        super(new String[]{SHOW_OK_CANCEL_KEY, ALLOWS_INVALID_KEY, PRINT_MOON_KEY, FIRST_DAY_OF_WEEK_KEY, HEADER_RENDERER_KEY, MODEL_KEY, RENDERER_KEY, SHOW_TODAY_KEY, TODAY_CAPTION_KEY, ANTI_ALIASED_KEY, WORKING_DAYS_KEY, "dateFormat", SHOW_WEEKNUMBERS_KEY});
    }

    protected Binding doBind(JComponent control, FormModel formModel, String formPropertyPath, Map context) {
        Assert.isTrue((boolean)(control instanceof DateField), (String)"Control must be an instance of DateField.");
        NachoCalendarDateFieldBinding binding = new NachoCalendarDateFieldBinding((DateField)control, formModel, formPropertyPath);
        this.applyContext(binding, context);
        return binding;
    }

    protected void applyContext(NachoCalendarDateFieldBinding binding, Map context) {
        super.applyContext(binding, context);
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)binding.getControl());
        Object dateFormat = context.get("dateFormat");
        context.remove("dateFormat");
        wrapper.setPropertyValues(context);
        if (dateFormat != null) {
            context.put("dateFormat", dateFormat);
        }
    }

    protected JComponent createControl(Map context) {
        final int preferredHeight = this.getComponentFactory().createComboBox().getPreferredSize().height;
        boolean showWeekNumbers = false;
        if (context.containsKey(SHOW_WEEKNUMBERS_KEY)) {
            showWeekNumbers = (Boolean)context.get(SHOW_WEEKNUMBERS_KEY);
            context.remove(SHOW_WEEKNUMBERS_KEY);
        }
        DateField dateField = new DateField(showWeekNumbers){
            private static final long serialVersionUID = 1L;

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.height = preferredHeight;
                return size;
            }
        };
        return dateField;
    }
}

