/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.springframework.binding.form.support.NestedPropertyChangeListener;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.BindingFactory;
import org.springframework.richclient.form.binding.swing.SwingBindingFactory;
import org.springframework.richclient.form.builder.AbstractFormBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormLayoutFormBuilder
extends AbstractFormBuilder {
    public static final String ALIGN_LEFT_TOP = "left, top";
    public static final String ALIGN_LEFT_CENTER = "left, center";
    public static final String ALIGN_LEFT_BOTTOM = "left, bottom";
    public static final String ALIGN_RIGHT_TOP = "right, top";
    public static final String ALIGN_RIGHT_CENTER = "right, center";
    public static final String ALIGN_RIGHT_BOTTOM = "right, bottom";
    private FormLayout layout;
    private JPanel panel;
    private CellConstraints cc;
    private String labelAttributes = "left, center";
    private String componentAttributes = null;
    private int row;
    private static final int DEFAULT_ROW_INCREMENT = 2;
    private FormModelEnabledListener formModelEnabledListener;

    public FormLayoutFormBuilder(BindingFactory bindingFactory, FormLayout layout) {
        this(bindingFactory, layout, new JPanel());
    }

    public FormLayoutFormBuilder(BindingFactory bindingFactory, FormLayout layout, JPanel panel) {
        super(bindingFactory);
        this.setLayout(layout, panel);
    }

    public FormLayoutFormBuilder nextRow() {
        return this.nextRow(FormFactory.DEFAULT_ROWSPEC);
    }

    public FormLayoutFormBuilder nextRow(String rowSpec) {
        return this.nextRow(RowSpec.decode((String)rowSpec));
    }

    public FormLayoutFormBuilder nextRow(RowSpec rowSpec) {
        this.row += 2;
        this.correctNumberOfRows(this.row, rowSpec);
        return this;
    }

    private void correctNumberOfRows(int requiredNrOfRows) {
        this.correctNumberOfRows(requiredNrOfRows, FormFactory.DEFAULT_ROWSPEC);
    }

    private void correctNumberOfRows(int requiredNrOfRows, RowSpec rowSpec) {
        int rowCount = this.layout.getRowCount();
        if (this.row == -1 && requiredNrOfRows == -1) {
            requiredNrOfRows = 1;
            this.row = 1;
        }
        if (requiredNrOfRows > rowCount) {
            for (int i = rowCount; i < requiredNrOfRows; i += 2) {
                if (i != 0) {
                    this.layout.appendRow(FormFactory.LINE_GAP_ROWSPEC);
                }
                this.layout.appendRow(rowSpec);
            }
        }
    }

    public int getRow() {
        if (this.row == -1) {
            this.row = 1;
        }
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
        this.correctNumberOfRows(row);
    }

    public void setLayout(FormLayout layout) {
        this.setLayout(layout, new JPanel());
    }

    public void setLayout(FormLayout layout, JPanel panel) {
        this.panel = panel;
        this.layout = layout;
        panel.setLayout((LayoutManager)layout);
        this.cc = new CellConstraints();
        this.row = -1;
    }

    public void setBorder(Border border) {
        this.panel.setBorder(border);
    }

    public JComponent addBinding(Binding binding) {
        return this.addBinding(binding, 1, this.row);
    }

    public JComponent addBinding(Binding binding, int column) {
        return this.addBinding(binding, column, this.row);
    }

    public JComponent addBinding(Binding binding, int column, int row) {
        return this.addBinding(binding, column, row, 1, 1);
    }

    public JComponent addBinding(Binding binding, int column, int row, int widthSpan, int heightSpan) {
        ((SwingBindingFactory)this.getBindingFactory()).interceptBinding(binding);
        JComponent component = binding.getControl();
        this.addComponent(component, column, row, widthSpan, heightSpan);
        return component;
    }

    public JComponent addProperty(String property) {
        return this.addProperty(property, 1, this.row);
    }

    public JComponent addProperty(String property, int column) {
        return this.addProperty(property, column, this.row);
    }

    public JComponent addProperty(String property, String binderId) {
        return this.addProperty(property, binderId, 1, this.row);
    }

    public JComponent addProperty(String property, String binderId, Map<?, ?> contextMap) {
        return this.addProperty(property, binderId, contextMap, 1, this.row);
    }

    public JComponent addProperty(String property, String binderId, int column) {
        return this.addProperty(property, binderId, column, this.row);
    }

    public JComponent addProperty(String property, String binderId, Map<?, ?> contextMap, int column) {
        return this.addProperty(property, binderId, contextMap, column, this.row);
    }

    public JComponent addProperty(String property, int column, int row) {
        return this.addProperty(property, column, row, 1, 1);
    }

    public JComponent addProperty(String property, String binderId, int column, int row) {
        return this.addProperty(property, binderId, column, row, 1, 1);
    }

    public JComponent addProperty(String property, String binderId, Map<?, ?> contextMap, int column, int row) {
        return this.addProperty(property, binderId, contextMap, column, row, 1, 1);
    }

    public JComponent addProperty(String property, int column, int row, int widthSpan, int heightSpan) {
        JComponent propertyComponent = this.createDefaultBinding(property).getControl();
        this.addComponent(propertyComponent, column, row, widthSpan, heightSpan);
        return propertyComponent;
    }

    public JComponent addProperty(String property, String binderId, int column, int row, int widthSpan, int heightSpan) {
        return this.addProperty(property, binderId, Collections.EMPTY_MAP, column, row, widthSpan, heightSpan);
    }

    public JComponent addProperty(String property, String binderId, Map<?, ?> contextMap, int column, int row, int widthSpan, int heightSpan) {
        JComponent propertyComponent = ((SwingBindingFactory)this.getBindingFactory()).createBinding(property, binderId, contextMap).getControl();
        this.addComponent(propertyComponent, column, row, widthSpan, heightSpan);
        return propertyComponent;
    }

    public JLabel addLabel(String property) {
        return this.addLabel(property, 1, this.row);
    }

    public JLabel addLabel(String property, int column) {
        return this.addLabel(property, column, this.row);
    }

    public JLabel addLabel(String property, int column, int row) {
        return this.addLabel(property, null, column, row);
    }

    public JLabel addLabel(String property, int column, int row, String attributes) {
        return this.addLabel(property, null, column, row, 1, 1, attributes);
    }

    public JLabel addLabel(String property, JComponent forComponent, int column, int row) {
        return this.addLabel(property, forComponent, column, row, 1, 1, this.labelAttributes);
    }

    public JLabel addLabel(String property, JComponent forComponent, int column, int row, int widthSpan, int heightSpan, String attributes) {
        JLabel labelComponent = this.createLabelFor(property, forComponent);
        this.row = row;
        if (this.row == -1) {
            this.row = 1;
        }
        this.correctNumberOfRows(this.row);
        this.panel.add((Component)labelComponent, this.cc.xywh(column, this.row, widthSpan, heightSpan, attributes));
        return labelComponent;
    }

    public void addComponent(JComponent component) {
        this.addComponent(component, 1, this.row, 1, 1);
    }

    public void addComponent(JComponent component, int column) {
        this.addComponent(component, column, this.row, 1, 1);
    }

    public void addComponent(JComponent component, int column, int row) {
        this.addComponent(component, column, row, 1, 1);
    }

    public void addComponent(JComponent component, int column, int row, int widthSpan, int heightSpan) {
        this.addComponent(component, column, row, widthSpan, heightSpan, this.componentAttributes);
    }

    public void addComponent(JComponent component, int column, int row, int widthSpan, int heightSpan, String attributes) {
        this.row = row;
        if (this.row == -1) {
            this.row = 1;
        }
        this.correctNumberOfRows(this.row);
        if (attributes == null) {
            this.panel.add((Component)component, this.cc.xywh(column, this.row, widthSpan, heightSpan));
        } else {
            this.panel.add((Component)component, this.cc.xywh(column, this.row, widthSpan, heightSpan, attributes));
        }
    }

    public JComponent[] addPropertyAndLabel(String property) {
        return this.addPropertyAndLabel(property, 1, this.row, this.labelAttributes);
    }

    public JComponent[] addPropertyAndLabel(String property, int column) {
        return this.addPropertyAndLabel(property, column, this.row, this.labelAttributes);
    }

    public JComponent[] addPropertyAndLabel(String property, String binderId) {
        return this.addPropertyAndLabel(property, binderId, 1, this.row, this.labelAttributes);
    }

    public JComponent[] addPropertyAndLabel(String property, int column, String binderId) {
        return this.addPropertyAndLabel(property, binderId, column, this.row, this.labelAttributes);
    }

    public JComponent[] addPropertyAndLabel(String property, int column, int row) {
        return this.addPropertyAndLabel(property, column, row, this.labelAttributes);
    }

    public JComponent[] addPropertyAndLabel(String property, String binderId, int column, int row) {
        return this.addPropertyAndLabel(property, binderId, column, row, this.labelAttributes);
    }

    public JComponent[] addPropertyAndLabel(String property, int column, int row, String attributes) {
        return this.addPropertyAndLabel(property, column, row, 1, attributes);
    }

    public JComponent[] addPropertyAndLabel(String property, String binderId, int column, int row, String attributes) {
        return this.addPropertyAndLabel(property, binderId, column, row, 1, attributes);
    }

    public JComponent[] addPropertyAndLabel(String property, int column, int row, int widthSpan) {
        return this.addPropertyAndLabel(property, column, row, widthSpan, this.labelAttributes);
    }

    public JComponent[] addPropertyAndLabel(String property, int column, int row, int widthSpan, String attributes) {
        return this.addPropertyAndLabel(property, column, row, widthSpan, 1, attributes);
    }

    public JComponent[] addPropertyAndLabel(String property, String binderId, int column, int row, int widthSpan, String attributes) {
        return this.addPropertyAndLabel(property, binderId, column, row, widthSpan, 1, attributes);
    }

    public JComponent[] addPropertyAndLabel(String property, int column, int row, int widthSpan, int heightSpan) {
        return this.addPropertyAndLabel(property, column, row, widthSpan, heightSpan, this.labelAttributes);
    }

    public JComponent[] addPropertyAndLabel(String property, String binderId, int column, int row, int widthSpan, int heightSpan) {
        return this.addPropertyAndLabel(property, binderId, column, row, widthSpan, heightSpan, this.labelAttributes);
    }

    public JComponent[] addPropertyAndLabel(String property, int column, int row, int widthSpan, int heightSpan, String attributes) {
        JComponent component = this.addProperty(property, column + 2, row, widthSpan, heightSpan);
        JLabel label = this.addLabel(property, component, column, row, 1, 1, attributes);
        return new JComponent[]{label, component};
    }

    public JComponent[] addPropertyAndLabel(String property, String binderId, int column, int row, int widthSpan, int heightSpan, String attributes) {
        JComponent component = this.addProperty(property, binderId, column + 2, row, widthSpan, heightSpan);
        JLabel label = this.addLabel(property, component, column, row, 1, 1, attributes);
        return new JComponent[]{label, component};
    }

    public JPanel getPanel() {
        this.getBindingFactory().getFormModel().revert();
        return this.panel;
    }

    public void setLabelAttributes(String attributes) {
        this.labelAttributes = attributes;
    }

    public void setComponentAttributes(String attributes) {
        this.componentAttributes = attributes;
    }

    public JComponent[] addTextArea(String propertyName, int column, int row) {
        return this.addTextArea(propertyName, column, row, 1, 1);
    }

    public JComponent[] addTextArea(String propertyName, int column) {
        return this.addTextArea(propertyName, column, this.row, 1, 1);
    }

    public JComponent[] addTextArea(String propertyName) {
        return this.addTextArea(propertyName, 1, this.row, 1, 1);
    }

    public JComponent[] addTextArea(String propertyName, int column, int row, int widthSpan, int heightSpan) {
        return this.addTextArea(propertyName, column, row, widthSpan, heightSpan, 20, 30);
    }

    public JComponent[] addTextArea(String propertyName, int column, int row, int widthSpan, int heightSpan, int vsbPolicy, int hsbPolicy) {
        JComponent textArea = this.createTextArea(propertyName);
        this.createBinding(propertyName, textArea);
        JScrollPane scrollPane = new JScrollPane(textArea, vsbPolicy, hsbPolicy);
        this.addComponent(scrollPane, column, row, widthSpan, heightSpan);
        return new JComponent[]{textArea, scrollPane};
    }

    public JComponent[] addTextAreaAndLabel(String propertyName, int column, int row) {
        return this.addTextAreaAndLabel(propertyName, column, row, 1, 1, this.labelAttributes);
    }

    public JComponent[] addTextAreaAndLabel(String propertyName, int column, int row, String attributes) {
        return this.addTextAreaAndLabel(propertyName, column, row, 1, 1, attributes);
    }

    public JComponent[] addTextAreaAndLabel(String propertyName, int column, int row, int widthSpan, int heightSpan) {
        return this.addTextAreaAndLabel(propertyName, column, row, widthSpan, heightSpan, this.labelAttributes);
    }

    public JComponent[] addTextAreaAndLabel(String propertyName, int column, int row, int widthSpan, int heightSpan, String attributes) {
        JLabel label = this.addLabel(propertyName, column, row, attributes);
        JComponent[] components = this.addTextArea(propertyName, column + 2, row, widthSpan, heightSpan);
        return new JComponent[]{label, components[0], components[1]};
    }

    public JComponent addPasswordField(String propertyName, int column) {
        return this.addPasswordField(propertyName, column, this.row, 1, 1);
    }

    public JComponent addPasswordField(String propertyName) {
        return this.addPasswordField(propertyName, 1, this.row);
    }

    public JComponent addPasswordField(String propertyName, int column, int row) {
        return this.addPasswordField(propertyName, column, row, 1, 1);
    }

    public JComponent addPasswordField(String propertyName, int column, int row, int widthSpan, int heightSpan) {
        JComponent passwordField = this.createBinding(propertyName, this.createPasswordField(propertyName)).getControl();
        this.addComponent(passwordField, column, row, widthSpan, heightSpan);
        return passwordField;
    }

    public JComponent[] addPasswordFieldAndLabel(String propertyName, int column) {
        return this.addPasswordFieldAndLabel(propertyName, column, this.row, 1, 1);
    }

    public JComponent[] addPasswordFieldAndLabel(String propertyName) {
        return this.addPasswordFieldAndLabel(propertyName, 1, this.row);
    }

    public JComponent[] addPasswordFieldAndLabel(String propertyName, int column, int row) {
        return this.addPasswordFieldAndLabel(propertyName, column, row, 1, 1, this.labelAttributes);
    }

    public JComponent[] addPasswordFieldAndLabel(String propertyName, int column, int row, String attributes) {
        return this.addPasswordFieldAndLabel(propertyName, column, row, 1, 1, attributes);
    }

    public JComponent[] addPasswordFieldAndLabel(String propertyName, int column, int row, int widthSpan, int heightSpan) {
        return this.addPasswordFieldAndLabel(propertyName, column, row, widthSpan, heightSpan, this.labelAttributes);
    }

    public JComponent[] addPasswordFieldAndLabel(String propertyName, int column, int row, int widthSpan, int heightSpan, String attributes) {
        JLabel label = this.addLabel(propertyName, column, row, attributes);
        JComponent component = this.addPasswordField(propertyName, column + 2, row, widthSpan, heightSpan);
        return new JComponent[]{label, component};
    }

    public void addHorizontalSeparator(int column, int row, int widthSpan) {
        this.addComponent(new JSeparator(), column, row, widthSpan, 1);
    }

    public void addHorizontalSeparator() {
        this.addComponent(new JSeparator(), 1, this.row, 1, 1);
    }

    public void addHorizontalSeparator(int widthSpan) {
        this.addComponent(new JSeparator(), 1, this.row, widthSpan, 1);
    }

    public void addHorizontalSeparator(int column, int widthSpan) {
        this.addComponent(new JSeparator(), column, this.row, widthSpan, 1);
    }

    public void addHorizontalSeparator(String text) {
        this.addComponent(this.getComponentFactory().createLabeledSeparator(text), 1, this.row, 1, 1);
    }

    public void addHorizontalSeparator(String text, int widthSpan) {
        this.addComponent(this.getComponentFactory().createLabeledSeparator(text), 1, this.row, widthSpan, 1);
    }

    public void addHorizontalSeparator(String text, int column, int widthSpan) {
        this.addComponent(this.getComponentFactory().createLabeledSeparator(text), column, this.row, widthSpan, 1);
    }

    public void addVerticalSeparator(int column, int row, int heightSpan) {
        this.addComponent(new JSeparator(1), column, row, 1, heightSpan);
    }

    public void addVerticalSeparator() {
        this.addComponent(new JSeparator(1), 1, this.row, 1, 1);
    }

    public void addVerticalSeparator(int heightSpan) {
        this.addComponent(new JSeparator(1), 1, this.row, 1, heightSpan);
    }

    public void addVerticalSeparator(int column, int heightSpan) {
        this.addComponent(new JSeparator(1), column, this.row, 1, heightSpan);
    }

    public JComponent addNestedPropertyReadOnly(String property, String nestedProperty) {
        return this.addNestedPropertyReadOnly(property, nestedProperty, 1, this.row);
    }

    public JComponent addNestedPropertyReadOnly(String property, String nestedProperty, int column) {
        return this.addNestedPropertyReadOnly(property, nestedProperty, column, this.row);
    }

    public JComponent addNestedPropertyReadOnly(String property, String nestedProperty, int column, int row) {
        return this.addNestedPropertyReadOnly(property, nestedProperty, column, row, 1, 1);
    }

    public JComponent addNestedPropertyReadOnly(String property, String nestedProperty, int column, int row, int widthSpan, int heightSpan) {
        JTextField nestedPropertyField = new JTextField();
        nestedPropertyField.setEditable(false);
        this.getFormModel().getValueModel(property).addValueChangeListener(new NestedPropertyChangeListener(nestedPropertyField, nestedProperty));
        this.getFormModelEnabledListener().add(nestedPropertyField);
        this.addComponent(nestedPropertyField, column, row, widthSpan, heightSpan);
        return nestedPropertyField;
    }

    public JComponent[] addNestedPropertyReadOnlyAndLabel(String property, String nestedProperty) {
        return this.addNestedPropertyReadOnlyAndLabel(property, nestedProperty, 1, this.row);
    }

    public JComponent[] addNestedPropertyReadOnlyAndLabel(String property, String nestedProperty, int column) {
        return this.addNestedPropertyReadOnlyAndLabel(property, nestedProperty, column, this.row);
    }

    public JComponent[] addNestedPropertyReadOnlyAndLabel(String property, String nestedProperty, int column, int row) {
        return this.addNestedPropertyReadOnlyAndLabel(property, nestedProperty, column, row, 1, 1);
    }

    public JComponent[] addNestedPropertyReadOnlyAndLabel(String property, String nestedProperty, int column, int row, int widthSpan, int heightSpan) {
        JTextField nestedPropertyField = new JTextField();
        nestedPropertyField.setEditable(false);
        this.getFormModel().getValueModel(property).addValueChangeListener(new NestedPropertyChangeListener(nestedPropertyField, nestedProperty));
        this.getFormModelEnabledListener().add(nestedPropertyField);
        JComponent comp = this.addNestedPropertyReadOnly(property, nestedProperty, column + 2, row, widthSpan, heightSpan);
        JLabel label = this.addLabel(property + "." + nestedProperty, comp, column, row, 1, 1, this.labelAttributes);
        return new JComponent[]{label, comp};
    }

    public FormModelEnabledListener getFormModelEnabledListener() {
        if (this.formModelEnabledListener == null) {
            this.formModelEnabledListener = new FormModelEnabledListener();
            this.getFormModel().addPropertyChangeListener("enabled", this.formModelEnabledListener);
        }
        return this.formModelEnabledListener;
    }

    public static class FormModelEnabledListener
    implements PropertyChangeListener {
        private List<JComponent> components = new ArrayList<JComponent>();

        public void propertyChange(PropertyChangeEvent evt) {
            for (JComponent component : this.components) {
                component.setEnabled((Boolean)evt.getNewValue());
            }
        }

        public void add(JComponent component) {
            this.components.add(component);
        }
    }
}

