/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder.support;

import java.util.Arrays;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.util.Assert;

public abstract class ConfigurableFormComponentInterceptorFactory
implements FormComponentInterceptorFactory,
InitializingBean {
    private String[] excludedFormModelIds;
    private String[] includedFormModelIds;

    public final FormComponentInterceptor getInterceptor(FormModel formModel) {
        if (this.excludedFormModelIds != null && Arrays.asList(this.excludedFormModelIds).contains(formModel.getId())) {
            return null;
        }
        if (this.includedFormModelIds != null && !Arrays.asList(this.includedFormModelIds).contains(formModel.getId())) {
            return null;
        }
        return this.createInterceptor(formModel);
    }

    protected abstract FormComponentInterceptor createInterceptor(FormModel var1);

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.excludedFormModelIds == null || this.includedFormModelIds == null ? 1 : 0) != 0, (String)"only one of excludedFormModelIds or includedFormModelIds can be given");
    }

    public String[] getExcludedFormModelIds() {
        return this.excludedFormModelIds;
    }

    public void setExcludedFormModelIds(String[] excludedFormModelIds) {
        this.excludedFormModelIds = excludedFormModelIds;
    }

    public String[] getIncludedFormModelIds() {
        return this.includedFormModelIds;
    }

    public void setIncludedFormModelIds(String[] includedFormModelIds) {
        this.includedFormModelIds = includedFormModelIds;
    }
}

