/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder.support;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.value.ValueChangeDetector;
import org.springframework.binding.value.support.ValueHolder;
import org.springframework.context.MessageSource;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.form.builder.support.AbstractFormComponentInterceptor;
import org.springframework.richclient.form.builder.support.InterceptorOverlayHelper;
import org.springframework.richclient.image.IconSource;

public class DirtyIndicatorInterceptor
extends AbstractFormComponentInterceptor {
    private static final String DIRTY_ICON_KEY = "dirty.overlay";
    private static final String DIRTY_MESSAGE_KEY = "dirty.message";
    private static final String REVERT_ICON_KEY = "revert.overlay";
    private static final String REVERT_MESSAGE_KEY = "revert.message";
    private ValueChangeDetector valueChangeDetector;

    public DirtyIndicatorInterceptor(FormModel formModel) {
        super(formModel);
    }

    public void processComponent(final String propertyName, JComponent component) {
        final OriginalValueHolder originalValueHolder = new OriginalValueHolder();
        final DirtyOverlay overlay = new DirtyOverlay(this.getFormModel(), propertyName, originalValueHolder);
        final ValueHolder reset = new ValueHolder(Boolean.FALSE);
        this.getFormModel().getValueModel(propertyName).addValueChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (reset.getValue() == Boolean.TRUE) {
                    originalValueHolder.reset();
                    reset.setValue(Boolean.FALSE);
                    overlay.setVisible(false);
                    return;
                }
                if (!originalValueHolder.isInitialized()) {
                    originalValueHolder.setOriginalValue(evt.getOldValue());
                }
                Object oldValue = originalValueHolder.getValue();
                Object newValue = evt.getNewValue();
                overlay.setVisible(DirtyIndicatorInterceptor.this.getValueChangeDetector().hasValueChanged(oldValue, newValue) && !DirtyIndicatorInterceptor.this.getFormModel().getFieldMetadata(propertyName).isReadOnly());
            }
        });
        this.getFormModel().getFormObjectHolder().addValueChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                reset.setValue(Boolean.TRUE);
            }
        });
        InterceptorOverlayHelper.attachOverlay(overlay.getControl(), component, 8, 5, 0);
        overlay.setVisible(false);
    }

    private ValueChangeDetector getValueChangeDetector() {
        if (this.valueChangeDetector == null) {
            this.valueChangeDetector = (ValueChangeDetector)ApplicationServicesLocator.services().getService(ValueChangeDetector.class);
        }
        return this.valueChangeDetector;
    }

    private static class OriginalValueHolder {
        private boolean initialized;
        private Object originalValue;

        private OriginalValueHolder() {
        }

        public void setOriginalValue(Object value) {
            this.initialized = true;
            this.originalValue = value;
        }

        public void reset() {
            this.initialized = false;
            this.originalValue = null;
        }

        public Object getValue() {
            return this.originalValue;
        }

        public boolean isInitialized() {
            return this.initialized;
        }
    }

    private static class DirtyOverlay
    extends AbstractControlFactory {
        private JButton revertButton;
        private JLabel dirtyLabel;
        private FormModel formModel;
        private String propertyName;
        private OriginalValueHolder originalValueHolder;

        public DirtyOverlay(FormModel formModel, String propertyName, OriginalValueHolder originalValueHolder) {
            this.formModel = formModel;
            this.propertyName = propertyName;
            this.originalValueHolder = originalValueHolder;
        }

        protected JComponent createControl() {
            JPanel control = new JPanel(new BorderLayout()){

                public void repaint() {
                    this.revalidate();
                    super.repaint();
                }
            };
            control.setName("dirtyOverlay");
            control.setOpaque(true);
            IconSource iconSource = (IconSource)ApplicationServicesLocator.services().getService(IconSource.class);
            Icon icon = iconSource.getIcon(DirtyIndicatorInterceptor.DIRTY_ICON_KEY);
            this.dirtyLabel = new JLabel(icon);
            control.add((Component)this.dirtyLabel, "Center");
            this.createRevertButton();
            control.add((Component)this.revertButton, "After");
            return control;
        }

        private void createRevertButton() {
            IconSource iconSource = (IconSource)ApplicationServicesLocator.services().getService(IconSource.class);
            Icon icon = iconSource.getIcon(DirtyIndicatorInterceptor.REVERT_ICON_KEY);
            this.revertButton = new JButton(icon);
            this.revertButton.setBorderPainted(false);
            this.revertButton.setContentAreaFilled(false);
            this.revertButton.setFocusable(false);
            this.revertButton.setMargin(new Insets(-3, -3, -3, -3));
            this.revertButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DirtyOverlay.this.formModel.getValueModel(DirtyOverlay.this.propertyName).setValue(DirtyOverlay.this.originalValueHolder.getValue());
                }
            });
        }

        public void setVisible(boolean visible) {
            this.getControl().setVisible(visible);
            this.getControl().setSize(this.getControl().getPreferredSize());
            if (visible) {
                MessageSource messageSource = (MessageSource)ApplicationServicesLocator.services().getService(MessageSource.class);
                String dirtyTooltip = messageSource.getMessage(DirtyIndicatorInterceptor.DIRTY_MESSAGE_KEY, new Object[]{this.formModel.getFieldFace(this.propertyName).getDisplayName(), this.originalValueHolder.getValue()}, Locale.getDefault());
                this.dirtyLabel.setToolTipText(dirtyTooltip);
                String revertTooltip = messageSource.getMessage(DirtyIndicatorInterceptor.REVERT_MESSAGE_KEY, new Object[]{this.formModel.getFieldFace(this.propertyName).getDisplayName()}, Locale.getDefault());
                this.revertButton.setToolTipText(revertTooltip);
            }
        }
    }
}

