/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.image;

import java.awt.Image;
import java.util.Iterator;
import javax.swing.ImageIcon;
import org.springframework.richclient.image.DefaultIconSource;
import org.springframework.richclient.image.IconSize;
import org.springframework.richclient.image.ImageSource;
import org.springframework.richclient.image.SizedIconSource;
import org.springframework.util.Assert;

public class ReloadableSizedIconSource
extends DefaultIconSource
implements SizedIconSource {
    private IconSize iconSize;

    public ReloadableSizedIconSource(IconSize iconSize, ImageSource iconResources) {
        super(iconResources);
        Assert.notNull((Object)iconSize);
        this.iconSize = iconSize;
    }

    public void reload(IconSize size) {
        Assert.notNull((Object)size);
        this.iconSize = size;
        Iterator keys = this.cache().keySet().iterator();
        if (!keys.hasNext()) {
            logger.warn((Object)"No icons currently in the registry--nothing to reload.");
            return;
        }
        while (keys.hasNext()) {
            this.reloadIconImage((String)keys.next());
        }
    }

    private void reloadIconImage(String key) {
        ImageIcon icon = (ImageIcon)this.cache().get(key);
        if (icon != null) {
            Image image = this.cache().images().getImage(this.appendIconSizeSuffix(key));
            icon.setImage(image);
        }
    }

    private String appendIconSizeSuffix(String key) {
        if (this.iconSize == null) {
            return key;
        }
        logger.debug((Object)("Appending icon suffix '." + this.iconSize.getName() + "'"));
        return key + "." + this.iconSize.getName();
    }

    protected String doProcessImageKeyBeforeLookup(String key) {
        return this.appendIconSizeSuffix(key);
    }
}

