/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

public class BeanPropertyValueComboBoxEditor
implements ComboBoxEditor {
    private final BeanWrapper beanWrapper = new BeanWrapperImpl();
    private Object current;
    private final ComboBoxEditor innerEditor;
    private final String renderedProperty;

    public BeanPropertyValueComboBoxEditor(ComboBoxEditor editor) {
        this(editor, null);
    }

    public BeanPropertyValueComboBoxEditor(ComboBoxEditor innerEditor, String renderedProperty) {
        this.innerEditor = innerEditor;
        this.renderedProperty = renderedProperty;
    }

    public BeanPropertyValueComboBoxEditor(String renderedProperty) {
        this(null, renderedProperty);
    }

    public void addActionListener(ActionListener l) {
        this.innerEditor.addActionListener(l);
    }

    public Component getEditorComponent() {
        return this.innerEditor.getEditorComponent();
    }

    public Object getItem() {
        return this.current;
    }

    public void removeActionListener(ActionListener l) {
        this.innerEditor.removeActionListener(l);
    }

    public void selectAll() {
        this.innerEditor.selectAll();
    }

    public void setItem(Object item) {
        this.current = item;
        if (item == null) {
            this.innerEditor.setItem("");
        } else {
            this.beanWrapper.setWrappedInstance(item);
            if (this.renderedProperty != null) {
                this.innerEditor.setItem(String.valueOf(this.beanWrapper.getPropertyValue(this.renderedProperty)));
            } else {
                this.innerEditor.setItem(String.valueOf(item));
            }
        }
    }

    public String getPropertyName() {
        return this.renderedProperty;
    }
}

