/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.progress;

import javax.swing.event.ListSelectionListener;
import org.springframework.richclient.application.statusbar.StatusBar;
import org.springframework.richclient.table.ListSelectionListenerSupport;
import org.springframework.util.Assert;

public abstract class ListStatusBarUpdater
extends ListSelectionListenerSupport
implements ListSelectionListener {
    private StatusBar statusBar;

    public ListStatusBarUpdater(StatusBar statusBar) {
        Assert.notNull((Object)statusBar);
        this.statusBar = statusBar;
    }

    protected abstract String getSelectedObjectName();

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    protected void onSingleSelection(int index) {
        this.updateStatusBar(this.getSelectedObjectName());
    }

    protected void onMultiSelection(int[] indexes) {
        this.updateStatusBar(this.getItemsSelected());
    }

    protected void onNoSelection() {
        this.updateStatusBar(null);
    }

    private void updateStatusBar(int itemsSelected) {
        this.getStatusBar().setMessage(itemsSelected + " items selected");
    }

    private void updateStatusBar(String selectedObjectName) {
        this.getStatusBar().setMessage(selectedObjectName);
    }
}

