/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.security;

import javax.swing.JComponent;
import org.springframework.richclient.form.AbstractForm;
import org.springframework.richclient.form.FormModelHelper;
import org.springframework.richclient.form.builder.TableFormBuilder;
import org.springframework.richclient.security.LoginDetails;
import org.springframework.security.Authentication;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class LoginForm
extends AbstractForm {
    private static final String FORM_ID = "credentials";
    private LoginDetails loginDetails = this.createLoginDetails();
    private JComponent usernameField;
    private JComponent passwordField;

    public LoginForm() {
        super(FORM_ID);
        this.setFormModel(FormModelHelper.createUnbufferedFormModel(this.loginDetails));
    }

    public void setUserName(String userName) {
        if (this.isControlCreated()) {
            this.getValueModel("username").setValue(userName);
        } else {
            this.loginDetails.setUsername(userName);
        }
    }

    public void setPassword(String password) {
        if (this.isControlCreated()) {
            this.getValueModel("password").setValue(password);
        } else {
            this.loginDetails.setPassword(password);
        }
    }

    public Authentication getAuthentication() {
        String username = this.loginDetails.getUsername().trim();
        String password = this.loginDetails.getPassword().trim();
        return new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
    }

    protected LoginDetails createLoginDetails() {
        return new LoginDetails();
    }

    protected JComponent createFormControl() {
        TableFormBuilder formBuilder = new TableFormBuilder(this.getBindingFactory());
        this.usernameField = formBuilder.add("username")[1];
        formBuilder.row();
        this.passwordField = formBuilder.addPasswordField("password")[1];
        return formBuilder.getForm();
    }

    public boolean requestFocusInWindow() {
        String username = this.loginDetails.getUsername();
        JComponent field = username != null && username.length() > 0 ? this.passwordField : this.usernameField;
        return field.requestFocusInWindow();
    }
}

