/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.security;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.remoting.caucho.BurlapProxyFactoryBean;
import org.springframework.remoting.caucho.HessianProxyFactoryBean;
import org.springframework.remoting.jaxrpc.JaxRpcPortProxyFactoryBean;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.security.ClientSecurityEvent;
import org.springframework.richclient.security.LoginEvent;
import org.springframework.richclient.security.LogoutEvent;
import org.springframework.security.Authentication;

public class RemotingSecurityConfigurer
implements ApplicationListener {
    protected static final Log logger = LogFactory.getLog(RemotingSecurityConfigurer.class);

    public void onApplicationEvent(ApplicationEvent event) {
        if (logger.isDebugEnabled() && event instanceof ClientSecurityEvent) {
            logger.debug((Object)("Processing event: " + event.toString()));
        }
        if (event instanceof LoginEvent) {
            Authentication authentication = (Authentication)event.getSource();
            this.updateExporters(authentication.getPrincipal().toString(), authentication.getCredentials().toString());
        } else if (event instanceof LogoutEvent) {
            this.updateExporters(null, null);
        }
    }

    private Object[] getExporters() {
        ApplicationContext appCtx = Application.instance().getApplicationContext();
        Vector list = new Vector();
        Class[] types = new Class[]{HessianProxyFactoryBean.class, BurlapProxyFactoryBean.class, JaxRpcPortProxyFactoryBean.class};
        for (int i = 0; i < types.length; ++i) {
            Map map = appCtx.getBeansOfType(types[i], false, true);
            for (Map.Entry entry : map.entrySet()) {
                String beanName = (String)entry.getKey();
                if (!beanName.startsWith("&")) continue;
                list.add(entry.getValue());
            }
        }
        return list.toArray();
    }

    private void updateExporters(String username, String password) {
        Object[] factories = this.getExporters();
        for (int i = 0; i < factories.length; ++i) {
            Method method;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Updating " + factories[i].toString() + " to username: " + username + "; password: [PROTECTED]"));
            }
            try {
                method = factories[i].getClass().getMethod("setUsername", String.class);
                method.invoke(factories[i], username);
            }
            catch (NoSuchMethodException ignored) {
                logger.error((Object)"Could not call setter", (Throwable)ignored);
            }
            catch (IllegalAccessException ignored) {
                logger.error((Object)"Could not call setter", (Throwable)ignored);
            }
            catch (InvocationTargetException ignored) {
                logger.error((Object)"Could not call setter", (Throwable)ignored);
            }
            try {
                method = factories[i].getClass().getMethod("setPassword", String.class);
                method.invoke(factories[i], password);
                continue;
            }
            catch (NoSuchMethodException ignored) {
                logger.error((Object)"Could not call setter", (Throwable)ignored);
                continue;
            }
            catch (IllegalAccessException ignored) {
                logger.error((Object)"Could not call setter", (Throwable)ignored);
                continue;
            }
            catch (InvocationTargetException ignored) {
                logger.error((Object)"Could not call setter", (Throwable)ignored);
            }
        }
    }
}

