/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.security;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.security.AuthenticationFailedEvent;
import org.springframework.richclient.security.ClientSecurityEvent;
import org.springframework.richclient.security.LoginEvent;
import org.springframework.richclient.security.LogoutEvent;
import org.springframework.rules.PropertyConstraintProvider;
import org.springframework.rules.Rules;
import org.springframework.rules.constraint.Constraint;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.SpringSecurityException;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class SessionDetails
implements Serializable,
PropertyConstraintProvider {
    public static final String PROPERTY_USERNAME = "username";
    public static final String PROPERTY_PASSWORD = "password";
    private static final Log logger = LogFactory.getLog(SessionDetails.class);
    private transient AuthenticationManager authenticationManager;
    private String username;
    private String password;
    private Rules validationRules;

    public SessionDetails() {
        if (SecurityContextHolder.getContext().getAuthentication() != null) {
            this.setUsername(SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString());
            this.setPassword(SecurityContextHolder.getContext().getAuthentication().getCredentials().toString());
        }
        this.initRules();
    }

    protected void initRules() {
        this.validationRules = new Rules(this.getClass()){

            protected void initRules() {
                this.add(SessionDetails.PROPERTY_USERNAME, this.all(new Constraint[]{this.required(), this.maxLength(this.getUsernameMaxLength())}));
                this.add(SessionDetails.PROPERTY_PASSWORD, this.all(new Constraint[]{this.required(), this.minLength(this.getPasswordMinLength())}));
            }

            protected int getUsernameMaxLength() {
                return 8;
            }

            protected int getPasswordMinLength() {
                return 2;
            }
        };
    }

    public PropertyConstraint getPropertyConstraint(String propertyName) {
        return this.validationRules.getPropertyConstraint(propertyName);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAuthenticationManager(AuthenticationManager manager) {
        this.authenticationManager = manager;
    }

    public void login() throws SpringSecurityException {
        ApplicationContext appCtx = Application.instance().getApplicationContext();
        UsernamePasswordAuthenticationToken request = new UsernamePasswordAuthenticationToken((Object)this.getUsername(), (Object)this.getPassword());
        Authentication result = null;
        try {
            result = this.authenticationManager.authenticate((Authentication)request);
        }
        catch (SpringSecurityException e) {
            logger.warn((Object)"authentication failed", (Throwable)e);
            appCtx.publishEvent((ApplicationEvent)new AuthenticationFailedEvent((Authentication)request, e));
            throw e;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"successful login - update context holder and fire event");
        }
        SecurityContextHolder.getContext().setAuthentication(result);
        appCtx.publishEvent((ApplicationEvent)new LoginEvent(result));
    }

    public static Authentication logout() {
        Authentication existing = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(null);
        if (existing == null) {
            existing = ClientSecurityEvent.NO_AUTHENTICATION;
        }
        ApplicationContext appCtx = Application.instance().getApplicationContext();
        appCtx.publishEvent((ApplicationEvent)new LogoutEvent(existing));
        return existing;
    }
}

