/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.security.support;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.richclient.core.Authorizable;
import org.springframework.richclient.security.SecurityController;
import org.springframework.security.AccessDecisionManager;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractSecurityController
implements SecurityController,
InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private List controlledObjects = new ArrayList();
    private AccessDecisionManager accessDecisionManager;
    private Authentication lastAuthentication = null;
    private HashSet postProcessorActionIds = new HashSet();
    private String postProcessorActionsToRun = "";
    public static final String VISIBLE_TRACKS_AUTHORIZED_ACTION = "visibleTracksAuthorized";

    protected AbstractSecurityController() {
        this.registerPostProcessorAction(VISIBLE_TRACKS_AUTHORIZED_ACTION);
    }

    protected abstract Object getSecuredObject();

    protected abstract ConfigAttributeDefinition getConfigAttributeDefinition(Object var1);

    public void setPostProcessorActionsToRun(String actions) {
        this.postProcessorActionsToRun = actions;
    }

    public String getPostProcessorActionsToRun() {
        return this.postProcessorActionsToRun;
    }

    protected void registerPostProcessorAction(String actionId) {
        if (this.postProcessorActionIds.contains(actionId)) {
            throw new IllegalArgumentException("Post-processor Action '" + actionId + "' is already registered");
        }
        this.postProcessorActionIds.add(actionId);
    }

    public void setAuthenticationToken(Authentication authentication) {
        this.setLastAuthentication(authentication);
        this.runAuthorization();
    }

    protected void runAuthorization() {
        boolean authorize = this.shouldAuthorize(this.getLastAuthentication());
        Iterator iter = this.controlledObjects.iterator();
        while (iter.hasNext()) {
            WeakReference ref = (WeakReference)iter.next();
            Authorizable controlledObject = (Authorizable)ref.get();
            if (controlledObject == null) {
                iter.remove();
                continue;
            }
            this.updateControlledObject(controlledObject, authorize);
        }
    }

    protected void updateControlledObject(Authorizable controlledObject, boolean authorized) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("setAuthorized( " + authorized + ") on: " + controlledObject));
        }
        controlledObject.setAuthorized(authorized);
        this.runPostProcessorActions(controlledObject, authorized);
    }

    protected void runPostProcessorActions(Object controlledObject, boolean authorized) {
        String actions = this.getPostProcessorActionsToRun();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Run post-processors actions: " + actions));
        }
        String[] actionIds = StringUtils.commaDelimitedListToStringArray((String)actions);
        for (int i = 0; i < actionIds.length; ++i) {
            this.doPostProcessorAction(actionIds[i], controlledObject, authorized);
        }
    }

    protected void doPostProcessorAction(String actionId, Object controlledObject, boolean authorized) {
        if (VISIBLE_TRACKS_AUTHORIZED_ACTION.equals(actionId)) {
            this.setVisibilityOnControlledObject(controlledObject, authorized);
        }
    }

    private void setVisibilityOnControlledObject(Object controlledObject, boolean authorized) {
        try {
            Method method = controlledObject.getClass().getMethod("setVisible", Boolean.TYPE);
            method.invoke(controlledObject, new Boolean(authorized));
        }
        catch (NoSuchMethodException ignored) {
            System.out.println("NO setVisible method on object: " + controlledObject);
        }
        catch (IllegalAccessException ignored) {
            this.logger.error((Object)"Could not call setVisible", (Throwable)ignored);
        }
        catch (InvocationTargetException ignored) {
            this.logger.error((Object)"Could not call setVisible", (Throwable)ignored);
        }
    }

    protected boolean shouldAuthorize(Authentication authentication) {
        Assert.state((this.getAccessDecisionManager() != null ? 1 : 0) != 0, (String)"The AccessDecisionManager can not be null!");
        boolean authorize = false;
        try {
            if (authentication != null) {
                Object securedObject = this.getSecuredObject();
                ConfigAttributeDefinition cad = this.getConfigAttributeDefinition(securedObject);
                this.getAccessDecisionManager().decide(authentication, this.getSecuredObject(), cad);
                authorize = true;
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        return authorize;
    }

    public void setAccessDecisionManager(AccessDecisionManager accessDecisionManager) {
        this.accessDecisionManager = accessDecisionManager;
    }

    public AccessDecisionManager getAccessDecisionManager() {
        return this.accessDecisionManager;
    }

    public void setControlledObjects(List secured) {
        this.controlledObjects = new ArrayList(secured.size());
        for (Object o : secured) {
            if (!(o instanceof Authorizable)) {
                throw new IllegalArgumentException("Controlled object must implement Authorizable, got " + o.getClass());
            }
            this.addAndPrepareControlledObject((Authorizable)o);
        }
    }

    public void addControlledObject(Authorizable object) {
        this.addAndPrepareControlledObject(object);
    }

    private void addAndPrepareControlledObject(Authorizable controlledObject) {
        this.controlledObjects.add(new WeakReference<Authorizable>(controlledObject));
        boolean authorize = this.shouldAuthorize(this.getLastAuthentication());
        this.updateControlledObject(controlledObject, authorize);
    }

    public Object removeControlledObject(Authorizable object) {
        Authorizable removed = null;
        Iterator iter = this.controlledObjects.iterator();
        while (iter.hasNext()) {
            WeakReference ref = (WeakReference)iter.next();
            Authorizable controlledObject = (Authorizable)ref.get();
            if (controlledObject == null) {
                iter.remove();
                continue;
            }
            if (!controlledObject.equals(object)) continue;
            removed = controlledObject;
            iter.remove();
        }
        return removed;
    }

    protected void setLastAuthentication(Authentication authentication) {
        this.lastAuthentication = authentication;
    }

    protected Authentication getLastAuthentication() {
        return this.lastAuthentication;
    }

    public void afterPropertiesSet() throws Exception {
        String[] actions = StringUtils.commaDelimitedListToStringArray((String)this.getPostProcessorActionsToRun());
        for (int i = 0; i < actions.length; ++i) {
            if (this.postProcessorActionIds.contains(actions[i])) continue;
            throw new IllegalArgumentException("Requested post-processor action '" + actions[i] + "' is not registered.");
        }
    }
}

