/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.security.support;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.security.ApplicationSecurityManager;
import org.springframework.richclient.security.AuthenticationEvent;
import org.springframework.richclient.security.AuthenticationFailedEvent;
import org.springframework.richclient.security.LoginEvent;
import org.springframework.richclient.security.LogoutEvent;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.SpringSecurityException;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.ProviderManager;

public class DefaultApplicationSecurityManager
implements ApplicationSecurityManager,
InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private AuthenticationManager authenticationManager = null;
    private Authentication currentAuthentication = null;

    public DefaultApplicationSecurityManager() {
        this(false);
    }

    public DefaultApplicationSecurityManager(boolean autoConfigure) {
        if (autoConfigure) {
            this.afterPropertiesSet();
        }
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public Authentication doLogin(Authentication authentication) {
        ApplicationContext appCtx = Application.instance().getApplicationContext();
        Authentication result = null;
        try {
            result = this.getAuthenticationManager().authenticate(authentication);
        }
        catch (SpringSecurityException e) {
            this.logger.info((Object)("authentication failed: " + e.getMessage()));
            appCtx.publishEvent((ApplicationEvent)new AuthenticationFailedEvent(authentication, e));
            throw e;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"successful login - update context holder and fire event");
        }
        SecurityContextHolder.getContext().setAuthentication(result);
        this.setAuthentication(result);
        appCtx.publishEvent((ApplicationEvent)new AuthenticationEvent(result));
        appCtx.publishEvent((ApplicationEvent)new LoginEvent(result));
        return result;
    }

    public boolean isUserLoggedIn() {
        return this.getAuthentication() != null;
    }

    public Authentication getAuthentication() {
        return this.currentAuthentication;
    }

    protected void setAuthentication(Authentication authentication) {
        this.currentAuthentication = authentication;
    }

    public boolean isUserInRole(String role) {
        boolean inRole = false;
        Authentication authentication = this.getAuthentication();
        if (authentication != null) {
            GrantedAuthority[] authorities = authentication.getAuthorities();
            for (int i = 0; i < authorities.length; ++i) {
                if (!role.equals(authorities[i].getAuthority())) continue;
                inRole = true;
                break;
            }
        }
        return inRole;
    }

    public Authentication doLogout() {
        Authentication existing = this.getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(null);
        this.setAuthentication(null);
        ApplicationContext appCtx = Application.instance().getApplicationContext();
        appCtx.publishEvent((ApplicationEvent)new AuthenticationEvent(null));
        appCtx.publishEvent((ApplicationEvent)new LogoutEvent(existing));
        return existing;
    }

    public void afterPropertiesSet() {
        if (this.authenticationManager == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No AuthenticationManager defined, look for one");
            }
            Class[] types = new Class[]{ProviderManager.class, AuthenticationProvider.class, AuthenticationManager.class};
            for (int i = 0; i < types.length && !this.tryToWire(types[i]); ++i) {
            }
        }
        if (this.authenticationManager == null) {
            throw new IllegalArgumentException("authenticationManager must be defined");
        }
    }

    protected boolean tryToWire(Class type) {
        boolean success = false;
        String className = type.getName();
        Map map = Application.instance().getApplicationContext().getBeansOfType(type);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Search for '" + className + "' found: " + map));
        }
        if (map.size() == 1) {
            Map.Entry entry = map.entrySet().iterator().next();
            String name = (String)entry.getKey();
            AuthenticationManager am = (AuthenticationManager)entry.getValue();
            this.setAuthenticationManager(am);
            success = true;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Auto-configuration using '" + name + "' as authenticationManager"));
            }
        } else if (map.size() > 1) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Need a single '" + className + "', found: " + map.keySet()));
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Auto-configuration did not find a suitable authenticationManager of type " + type));
        }
        return success;
    }
}

