/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.selection.dialog;

import java.awt.Window;
import javax.swing.JComponent;
import org.springframework.richclient.dialog.ApplicationDialog;
import org.springframework.richclient.layout.TableLayoutBuilder;
import org.springframework.rules.closure.Closure;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractSelectionDialog
extends ApplicationDialog {
    private String description;
    private Closure onSelectAction;
    private Closure onAboutToShow;

    public AbstractSelectionDialog(String title, Window parent) {
        super(title, parent);
    }

    protected JComponent createDialogContentPane() {
        TableLayoutBuilder builder = new TableLayoutBuilder();
        JComponent selectionComponent = this.createSelectionComponent();
        Assert.state((selectionComponent != null ? 1 : 0) != 0, (String)"createSelectionComponent cannot return null");
        if (StringUtils.hasText((String)this.description)) {
            builder.cell(this.getComponentFactory().createLabelFor(this.description, selectionComponent));
            builder.relatedGapRow();
            builder.row();
        }
        builder.cell(selectionComponent);
        return builder.getPanel();
    }

    protected abstract JComponent createSelectionComponent();

    protected boolean onFinish() {
        this.onSelect(this.getSelectedObject());
        return true;
    }

    public void setDescription(String desc) {
        Assert.isTrue((!this.isControlCreated() ? 1 : 0) != 0, (String)"Set the description before the control is created.");
        this.description = desc;
    }

    protected abstract Object getSelectedObject();

    protected void onSelect(Object selection) {
        if (this.onSelectAction == null) {
            throw new UnsupportedOperationException("Either provide an onSelectAction or override the onSelect method");
        }
        this.onSelectAction.call(selection);
    }

    public void setOnSelectAction(Closure onSelectAction) {
        this.onSelectAction = onSelectAction;
    }

    public void setOnAboutToShow(Closure onAboutToShow) {
        this.onAboutToShow = onAboutToShow;
    }

    protected void onAboutToShow() {
        if (this.onAboutToShow != null) {
            this.onAboutToShow.call(null);
        }
    }
}

