/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.springframework.binding.value.support.ObservableList;
import org.springframework.richclient.table.MutableTableModel;
import org.springframework.richclient.util.Assert;

public abstract class BaseTableModel
extends AbstractTableModel
implements MutableTableModel {
    private Class[] columnClasses;
    private String[] columnNames;
    private List rows;
    private boolean rowNumbers = true;

    public BaseTableModel() {
        this.rows = new ArrayList();
    }

    public BaseTableModel(List rows) {
        this.rows = rows == null ? new ArrayList() : rows;
    }

    public void setRows(List rows) {
        if (rows == null) {
            this.rows = new ArrayList();
        }
        if (this.rows == rows) {
            return;
        }
        this.rows = rows;
        this.fireTableDataChanged();
    }

    public void setRowNumbers(boolean rowNumbers) {
        if (this.rowNumbers != rowNumbers) {
            this.rowNumbers = rowNumbers;
            this.createColumnInfo();
        }
    }

    public boolean hasRowNumbers() {
        return this.rowNumbers;
    }

    protected void createColumnInfo() {
        Class[] newColumnClasses = this.createColumnClasses();
        String[] newColumnNames = this.createColumnNames();
        if (this.rowNumbers) {
            this.columnClasses = new Class[newColumnClasses.length + 1];
            this.columnClasses[0] = Integer.class;
            System.arraycopy(newColumnClasses, 0, this.columnClasses, 1, newColumnClasses.length);
            this.columnNames = new String[newColumnNames.length + 1];
            this.columnNames[0] = " ";
            System.arraycopy(newColumnNames, 0, this.columnNames, 1, newColumnNames.length);
        } else {
            this.columnClasses = newColumnClasses;
            this.columnNames = newColumnNames;
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getDataColumnCount() {
        return this.rowNumbers ? this.columnNames.length - 1 : this.getColumnCount();
    }

    public Class getColumnClass(int columnIndex) {
        return this.columnClasses[columnIndex];
    }

    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    public String[] getColumnHeaders() {
        return this.columnNames;
    }

    public String[] getDataColumnHeaders() {
        String[] headers = this.getColumnHeaders();
        if (!this.hasRowNumbers()) {
            return headers;
        }
        String[] dataHeaders = new String[headers.length - 1];
        System.arraycopy(headers, 1, dataHeaders, 0, headers.length - 1);
        return dataHeaders;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.rowNumbers) {
            if (columnIndex == 0) {
                return new Integer(rowIndex + 1);
            }
            --columnIndex;
        }
        return this.getValueAtInternal(this.rows.get(rowIndex), columnIndex);
    }

    protected abstract Object getValueAtInternal(Object var1, int var2);

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.rowNumbers) {
            if (columnIndex == 0) {
                return false;
            }
            --columnIndex;
        }
        return this.isCellEditableInternal(this.rows.get(rowIndex), columnIndex);
    }

    protected boolean isCellEditableInternal(Object row, int columnIndex) {
        return false;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (this.rowNumbers) {
            --columnIndex;
        }
        this.setValueAtInternal(value, this.rows.get(rowIndex), columnIndex);
        if (this.getRows() instanceof ObservableList) {
            ((ObservableList)this.getRows()).getIndexAdapter(rowIndex).fireIndexedObjectChanged();
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    protected void setValueAtInternal(Object value, Object row, int columnIndex) {
    }

    public Object getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public List getRows() {
        return this.rows;
    }

    public List getColumnData(int column) {
        int columnCount = this.getColumnCount();
        if (column < 0 || column >= columnCount) {
            throw new IndexOutOfBoundsException("The given column index [" + column + "] is outside the bounds of the number of columns [" + columnCount + "] in the rows of this table model.");
        }
        if (columnCount == 1) {
            return this.rows;
        }
        ArrayList<Object> colData = new ArrayList<Object>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            colData.add(this.getValueAt(i, column));
        }
        return colData;
    }

    public int rowOf(Object obj) {
        if (obj == null) {
            return -1;
        }
        return this.rows.indexOf(obj);
    }

    public void addRow(Object row) {
        Assert.required(row, "row");
        this.rows.add(row);
        int index = this.rows.size() - 1;
        this.fireTableRowsInserted(index, index);
    }

    public void addRows(List newRows) {
        Assert.required(newRows, "newRows");
        if (newRows.isEmpty()) {
            return;
        }
        int firstRow = this.rows.size();
        this.rows.addAll(newRows);
        int lastRow = this.rows.size() - 1;
        this.fireTableRowsInserted(firstRow, lastRow);
    }

    public void remove(int index) {
        this.rows.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void remove(int firstIndex, int lastIndex) {
        if (lastIndex < firstIndex) {
            throw new IllegalArgumentException("lastIndex [" + lastIndex + "] cannot be less than firstIndex [" + firstIndex + "]");
        }
        if (firstIndex < 0 || firstIndex >= this.rows.size()) {
            throw new IndexOutOfBoundsException("The specified starting index [" + firstIndex + "] is outside the bounds of the rows collection " + "which only has [" + this.rows.size() + "] elements.");
        }
        if (lastIndex >= this.rows.size()) {
            throw new IndexOutOfBoundsException("The specified end index [" + lastIndex + "] is outside the bounds of the rows collection " + "which only has [" + this.rows.size() + "] elements.");
        }
        int rowCount = lastIndex - firstIndex + 1;
        for (int i = 0; i < rowCount; ++i) {
            this.rows.remove(firstIndex);
        }
        this.fireTableRowsDeleted(firstIndex, lastIndex);
    }

    public void remove(int[] indexes) {
        Assert.required(indexes, "indexes");
        if (indexes.length == 0) {
            return;
        }
        Arrays.sort(indexes);
        if (indexes[0] < 0 || indexes[0] >= this.rows.size()) {
            throw new IndexOutOfBoundsException("The specified index [" + indexes[0] + "] is outside the bounds of the rows collection " + "which only has [" + this.rows.size() + "] elements.");
        }
        if (indexes[indexes.length - 1] >= this.rows.size()) {
            throw new IndexOutOfBoundsException("The specified end index [" + indexes[indexes.length - 1] + "] is outside the bounds of the rows collection " + "which only has [" + this.rows.size() + "] elements.");
        }
        int firstIndex = indexes[0];
        int lastIndex = indexes[0];
        int shift = 0;
        for (int i = 0; i < indexes.length - 1; ++i) {
            if (indexes[i + 1] == lastIndex + 1) {
                ++lastIndex;
                continue;
            }
            this.remove(firstIndex - shift, lastIndex - shift);
            shift += lastIndex - firstIndex + 1;
            firstIndex = indexes[i + 1];
            lastIndex = indexes[i + 1];
        }
        this.remove(firstIndex - shift, lastIndex - shift);
    }

    public void clear() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    protected Class[] getColumnClasses() {
        return this.columnClasses;
    }

    protected String[] getColumnNames() {
        return this.columnNames;
    }

    protected abstract Class[] createColumnClasses();

    protected abstract String[] createColumnNames();
}

