/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.springframework.richclient.table.MutableTableModel;
import org.springframework.richclient.table.TableDataProvider;

public class TableUpdater
extends Thread {
    private int sleepTime = 3000;
    private int eqSleepTime = 1000;
    private boolean updatesEnabled = true;
    private Runnable publishRunnable;
    private Runnable emptyRunnable;
    private TableDataProvider tableDataProvider;
    private MutableTableModel tableModel;
    private boolean done;

    public TableUpdater(TableDataProvider provider, MutableTableModel tableModel) {
        this.setPriority(1);
        this.updatesEnabled = true;
        this.tableDataProvider = provider;
        this.tableModel = tableModel;
        this.publishRunnable = new Runnable(){

            public void run() {
                TableUpdater.this.publishChangesOnEventDispatchingThread();
            }
        };
        this.emptyRunnable = new Runnable(){

            public void run() {
            }
        };
    }

    public void interrupt() {
        this.done = true;
        super.interrupt();
    }

    public void run() {
        while (!this.isInterrupted() && !this.done) {
            try {
                TableUpdater.sleep(this.sleepTime);
                this.waitForUpdatesEnabled();
                this.waitForIdleEventQueue();
                this.publishChanges();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForUpdatesEnabled() {
        TableUpdater tableUpdater = this;
        synchronized (tableUpdater) {
            while (!this.updatesEnabled) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void waitForIdleEventQueue() {
        EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (queue.peekEvent() != null) {
            try {
                TableUpdater.sleep(this.eqSleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void publishChanges() {
        try {
            SwingUtilities.invokeAndWait(this.publishRunnable);
        }
        catch (InterruptedException ie) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
        try {
            SwingUtilities.invokeAndWait(this.emptyRunnable);
        }
        catch (InterruptedException ie) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private void publishChangesOnEventDispatchingThread() {
        List newRows = this.tableDataProvider.takeData();
        if (newRows.size() > 0) {
            this.tableModel.addRows(newRows);
            RepaintManager.currentManager(null).paintDirtyRegions();
            newRows.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdatesEnabled(boolean enable) {
        TableUpdater tableUpdater = this;
        synchronized (tableUpdater) {
            this.updatesEnabled = enable;
            if (this.updatesEnabled) {
                this.notify();
            }
        }
    }

    public boolean getUpdatesEnabled() {
        return this.updatesEnabled;
    }
}

