/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.springframework.core.enums.LetterCodedLabeledEnum;
import org.springframework.core.enums.ShortCodedLabeledEnum;
import org.springframework.core.enums.StringCodedLabeledEnum;
import org.springframework.richclient.table.AbstractTableModelFilter;
import org.springframework.richclient.table.ShuttleSortableTableModel;
import org.springframework.richclient.table.SortTableCommand;
import org.springframework.richclient.table.TableSortIndicator;
import org.springframework.richclient.table.renderer.BeanTableCellRenderer;
import org.springframework.richclient.table.renderer.BooleanTableCellRenderer;
import org.springframework.richclient.table.renderer.DateTimeTableCellRenderer;
import org.springframework.richclient.table.renderer.LabeledEnumTableCellRenderer;
import org.springframework.richclient.util.WindowUtils;

public class TableUtils {
    public static void scrollToRow(JTable table, int row) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(row, 0, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    public static JTable createStandardSortableTable(TableModel tableModel) {
        JTable table = new JTable(tableModel);
        table.setAutoResizeMode(0);
        TableUtils.installDefaultRenderers(table);
        TableUtils.attachSorter(table);
        TableUtils.sizeColumnsToFitRowData(table);
        return table;
    }

    public static JTable attachSorter(JTable table) {
        TableModel tableModel = table.getModel();
        ShuttleSortableTableModel sortedModel = new ShuttleSortableTableModel(tableModel);
        table.setAutoCreateColumnsFromModel(true);
        table.setModel(sortedModel);
        TableSortIndicator sortIndicator = new TableSortIndicator(table);
        new SortTableCommand(table, sortIndicator.getColumnSortList());
        return table;
    }

    public static void installDefaultRenderers(JTable table) {
        BeanTableCellRenderer beanRenderer = new BeanTableCellRenderer();
        table.setDefaultRenderer(Object.class, beanRenderer);
        LabeledEnumTableCellRenderer er = new LabeledEnumTableCellRenderer();
        table.setDefaultRenderer(ShortCodedLabeledEnum.class, er);
        table.setDefaultRenderer(StringCodedLabeledEnum.class, er);
        table.setDefaultRenderer(LetterCodedLabeledEnum.class, er);
        table.setDefaultRenderer(Date.class, new DateTimeTableCellRenderer());
        table.setDefaultRenderer(Boolean.class, new BooleanTableCellRenderer());
    }

    public static void setPreferredColumnWidths(JTable table) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            TableColumn col = table.getColumnModel().getColumn(i);
            int w = TableUtils.calculatePreferredColumnWidth(table, col);
            col.setPreferredWidth(w);
            col.setWidth(w);
        }
    }

    public static int calculatePreferredColumnWidth(JTable table, TableColumn col) {
        TableModel model = table.getModel();
        String colName = model.getColumnName(col.getModelIndex());
        return new JLabel((String)colName).getPreferredSize().width + 17 + 11;
    }

    public static TableModel getUnfilteredTableModel(JTable table) {
        return TableUtils.getUnfilteredTableModel(table.getModel());
    }

    public static void sizeColumnsToFitRowData(JTable table) {
        TableUtils.sizeColumnsToFitRowData(table, 1);
    }

    public static void sizeColumnsToFitRowData(JTable table, int maxNumberOfRows) {
        if (table.getRowCount() > 0) {
            int rowSize = maxNumberOfRows <= 0 ? table.getRowCount() : Math.min(maxNumberOfRows, table.getRowCount());
            int colSize = table.getColumnCount();
            for (int col = 0; col < colSize; ++col) {
                int width = 0;
                TableColumn column = table.getColumnModel().getColumn(col);
                TableCellRenderer r = table.getColumnModel().getColumn(col).getCellRenderer();
                for (int row = 0; row < rowSize; ++row) {
                    Object val = table.getValueAt(row, col);
                    if (r == null && val != null) {
                        r = table.getDefaultRenderer(val.getClass());
                    }
                    if (r == null) continue;
                    Component c = r.getTableCellRendererComponent(table, val, false, false, row, col);
                    int cWidth = c.getPreferredSize().width;
                    if (cWidth <= width) continue;
                    width = cWidth;
                }
                column.setPreferredWidth(width + 5);
                column.setWidth(column.getPreferredWidth());
            }
        }
        int width = Math.min(table.getColumnModel().getTotalColumnWidth(), (int)((double)WindowUtils.getScreenWidth() * 0.75));
        table.setPreferredScrollableViewportSize(new Dimension(width, 300));
    }

    public static TableModel getUnfilteredTableModel(TableModel tableModel) {
        if (tableModel instanceof AbstractTableModelFilter) {
            return TableUtils.getUnfilteredTableModel(((AbstractTableModelFilter)tableModel).getFilteredModel());
        }
        return tableModel;
    }

    public static void stopCellEditing(JTable table) {
        int row = table.getEditingRow();
        int col = table.getEditingColumn();
        if (table.isEditing() && row < table.getRowCount()) {
            table.getCellEditor(row, col).stopCellEditing();
        }
    }
}

