/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class VisibleTableModelEvent
extends TableModelEvent {
    private Point tmpPoint = new Point();
    private boolean valid;
    private int firstVisRow;
    private int lastVisRow;
    private int firstVisCol;
    private int lastVisCol;

    public VisibleTableModelEvent(TableModel source) {
        super(source, 0, 0, 0, 0);
    }

    public void set(int row, int col) {
        this.firstRow = row;
        this.lastRow = row;
        this.column = col;
    }

    public void reset() {
        this.valid = false;
    }

    public boolean isVisible(JTable table) {
        if (!this.valid) {
            Rectangle visRect = table.getVisibleRect();
            this.tmpPoint.x = visRect.x;
            this.tmpPoint.y = visRect.y;
            this.firstVisCol = table.columnAtPoint(this.tmpPoint);
            this.firstVisRow = table.rowAtPoint(this.tmpPoint);
            this.tmpPoint.x += visRect.width;
            this.tmpPoint.y += visRect.height;
            this.lastVisCol = table.columnAtPoint(this.tmpPoint);
            if (this.lastVisCol == -1) {
                this.lastVisCol = table.getColumnCount() - 1;
            }
            if ((this.lastVisRow = table.rowAtPoint(this.tmpPoint)) == -1) {
                this.lastVisRow = table.getRowCount();
            }
            this.valid = true;
        }
        return this.firstRow >= this.firstVisRow && this.firstRow <= this.lastVisRow && this.column >= this.firstVisCol && this.column <= this.lastVisCol;
    }
}

