/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class OptimizedTableCellRenderer
extends DefaultTableCellRenderer {
    protected Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
    protected Color background = UIManager.getColor("Table.focusCellBackground");
    protected Color foreground = UIManager.getColor("Table.focusCellForeground");
    protected Color editableForeground;
    protected Color editableBackground;

    protected void doPrepareRenderer(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setValue(value);
        return this;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void paint(Graphics g) {
        this.ui.update(g, this);
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setForeground(Color c) {
        this.foreground = c;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public boolean isOpaque() {
        return this.background != null;
    }

    public void invalidate() {
    }

    public void repaint() {
    }
}

