/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.text;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.springframework.binding.form.CommitListener;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.value.CommitTrigger;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.richclient.form.builder.support.AbstractFormComponentInterceptor;
import org.springframework.richclient.text.TextComponentContainer;
import org.springframework.richclient.text.TextComponentPopup;

public class TextComponentPopupInterceptorFactory
implements FormComponentInterceptorFactory {
    public FormComponentInterceptor getInterceptor(FormModel formModel) {
        return new TextComponentPopupInterceptor(formModel);
    }

    private class TextComponentPopupInterceptor
    extends AbstractFormComponentInterceptor
    implements PropertyChangeListener,
    CommitListener {
        private CommitTrigger resetTrigger;

        protected TextComponentPopupInterceptor(FormModel formModel) {
            super(formModel);
        }

        public void processComponent(String propertyName, JComponent component) {
            JComponent innerComp = this.getInnerComponent(component);
            if (innerComp instanceof JTextComponent) {
                TextComponentPopup.attachPopup((JTextComponent)innerComp, this.getResetTrigger());
            } else if (innerComp instanceof TextComponentContainer) {
                TextComponentPopup.attachPopup(((TextComponentContainer)((Object)innerComp)).getComponent(), this.getResetTrigger());
            }
        }

        private CommitTrigger getResetTrigger() {
            if (this.resetTrigger == null) {
                this.resetTrigger = new CommitTrigger();
                this.registerListeners();
            }
            return this.resetTrigger;
        }

        private void registerListeners() {
            FormModel formModel = this.getFormModel();
            formModel.addCommitListener(this);
            formModel.getFormObjectHolder().addValueChangeListener(this);
        }

        public void preCommit(FormModel formModel) {
        }

        public void postCommit(FormModel formModel) {
            this.resetTrigger.commit();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.resetTrigger.commit();
        }
    }
}

