/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;

public class EventListenerListHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            throw new UnsupportedOperationException();
        }
    };
    private static final Map methodCache = new CachingMapDecorator(){

        protected Object create(Object o) {
            MethodCacheKey key = (MethodCacheKey)o;
            Method fireMethod = null;
            Method[] methods = key.listenerClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(key.methodName) || method.getParameterTypes().length != key.numParams) continue;
                if (fireMethod != null) {
                    throw new UnsupportedOperationException("Listener class [" + key.listenerClass + "] has more than 1 implementation of method [" + key.methodName + "] with [" + key.numParams + "] parameters.");
                }
                fireMethod = method;
            }
            if (fireMethod == null) {
                throw new IllegalArgumentException("Listener class [" + key.listenerClass + "] does not implement method [" + key.methodName + "] with [" + key.numParams + "] parameters.");
            }
            return fireMethod;
        }
    };
    private final Class listenerClass;
    private volatile Object[] listeners = EMPTY_OBJECT_ARRAY;

    public EventListenerListHelper(Class listenerClass) {
        Assert.notNull((Object)listenerClass, (String)"The listenerClass argument is required");
        this.listenerClass = listenerClass;
    }

    public boolean hasListeners() {
        return this.listeners.length > 0;
    }

    public boolean isEmpty() {
        return !this.hasListeners();
    }

    public int getListenerCount() {
        return this.listeners.length;
    }

    protected Object[] getListeners() {
        return this.listeners;
    }

    public Iterator iterator() {
        if (this.listeners == EMPTY_OBJECT_ARRAY) {
            return EMPTY_ITERATOR;
        }
        return new ObjectArrayIterator(this.listeners);
    }

    public void fire(String methodName) {
        if (this.listeners != EMPTY_OBJECT_ARRAY) {
            this.fireEventByReflection(methodName, EMPTY_OBJECT_ARRAY);
        }
    }

    public void fire(String methodName, Object arg) {
        if (this.listeners != EMPTY_OBJECT_ARRAY) {
            this.fireEventByReflection(methodName, new Object[]{arg});
        }
    }

    public void fire(String methodName, Object arg1, Object arg2) {
        if (this.listeners != EMPTY_OBJECT_ARRAY) {
            this.fireEventByReflection(methodName, new Object[]{arg1, arg2});
        }
    }

    public void fire(String methodName, Object[] args) {
        if (this.listeners != EMPTY_OBJECT_ARRAY) {
            this.fireEventByReflection(methodName, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object listener) {
        if (listener == null) {
            return false;
        }
        this.checkListenerType(listener);
        EventListenerListHelper eventListenerListHelper = this;
        synchronized (eventListenerListHelper) {
            if (this.listeners == EMPTY_OBJECT_ARRAY) {
                this.listeners = new Object[]{listener};
            } else {
                int listenersLength = this.listeners.length;
                for (int i = 0; i < listenersLength; ++i) {
                    if (this.listeners[i] != listener) continue;
                    return false;
                }
                Object[] tmp = new Object[listenersLength + 1];
                tmp[listenersLength] = listener;
                System.arraycopy(this.listeners, 0, tmp, 0, listenersLength);
                this.listeners = tmp;
            }
        }
        return true;
    }

    public boolean addAll(Object[] listenersToAdd) {
        if (listenersToAdd == null) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < listenersToAdd.length; ++i) {
            if (!this.add(listenersToAdd[i])) continue;
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object listener) {
        this.checkListenerType(listener);
        EventListenerListHelper eventListenerListHelper = this;
        synchronized (eventListenerListHelper) {
            int index;
            if (this.listeners == EMPTY_OBJECT_ARRAY) {
                return;
            }
            int listenersLength = this.listeners.length;
            for (index = 0; index < listenersLength && this.listeners[index] != listener; ++index) {
            }
            if (index < listenersLength) {
                if (listenersLength == 1) {
                    this.listeners = EMPTY_OBJECT_ARRAY;
                } else {
                    Object[] tmp = new Object[listenersLength - 1];
                    System.arraycopy(this.listeners, 0, tmp, 0, index);
                    if (index < tmp.length) {
                        System.arraycopy(this.listeners, index + 1, tmp, index, tmp.length - index);
                    }
                    this.listeners = tmp;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        EventListenerListHelper eventListenerListHelper = this;
        synchronized (eventListenerListHelper) {
            if (this.listeners == EMPTY_OBJECT_ARRAY) {
                return;
            }
            this.listeners = EMPTY_OBJECT_ARRAY;
        }
    }

    private void fireEventByReflection(String methodName, Object[] eventArgs) {
        Method eventMethod = (Method)methodCache.get(new MethodCacheKey(this.listenerClass, methodName, eventArgs.length));
        Object[] listenersCopy = this.listeners;
        for (int i = 0; i < listenersCopy.length; ++i) {
            try {
                eventMethod.invoke(listenersCopy[i], eventArgs);
                continue;
            }
            catch (InvocationTargetException e) {
                throw new EventBroadcastException("Exception thrown by listener", e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new EventBroadcastException("Unable to invoke listener", e);
            }
        }
    }

    private void checkListenerType(Object listener) {
        if (!this.listenerClass.isInstance(listener)) {
            throw new IllegalArgumentException("Listener [" + listener + "] is not an instance of [" + this.listenerClass + "].");
        }
    }

    public Object toArray() {
        if (this.listeners == EMPTY_OBJECT_ARRAY) {
            return Array.newInstance(this.listenerClass, 0);
        }
        Object[] listenersCopy = this.listeners;
        Object copy = Array.newInstance(this.listenerClass, listenersCopy.length);
        System.arraycopy(listenersCopy, 0, copy, 0, listenersCopy.length);
        return copy;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("listenerClass", (Object)this.listenerClass).append("listeners", (Object)this.listeners).toString();
    }

    private static class MethodCacheKey {
        public final Class listenerClass;
        public final String methodName;
        public final int numParams;

        public MethodCacheKey(Class listenerClass, String methodName, int numParams) {
            Assert.notNull((Object)listenerClass);
            Assert.notNull((Object)methodName);
            this.listenerClass = listenerClass;
            this.methodName = methodName;
            this.numParams = numParams;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof MethodCacheKey)) {
                return false;
            }
            MethodCacheKey k2 = (MethodCacheKey)o2;
            return this.listenerClass.equals(k2.listenerClass) && this.methodName.equals(k2.methodName) && this.numParams == k2.numParams;
        }

        public int hashCode() {
            return this.listenerClass.hashCode() ^ this.methodName.hashCode() ^ this.numParams;
        }
    }

    private static class ObjectArrayIterator
    implements Iterator {
        private final Object[] array;
        private int index;

        public ObjectArrayIterator(Object[] array) {
            this.array = array;
        }

        public boolean hasNext() {
            return this.index < this.array.length;
        }

        public Object next() {
            if (this.index > this.array.length - 1) {
                throw new NoSuchElementException();
            }
            return this.array[this.index++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class EventBroadcastException
    extends NestedRuntimeException {
        public EventBroadcastException(String msg, Throwable ex) {
            super(msg, ex);
        }
    }
}

