/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import java.awt.GridBagConstraints;
import java.awt.Insets;

public class GridBagCellConstraints {
    public static Insets RIGHT_INSETS = new Insets(0, 0, 0, 5);
    public static Insets LEFT_INSETS = new Insets(0, 5, 0, 0);
    public static Insets TOP_INSETS = new Insets(5, 0, 0, 0);
    public static Insets BOTTOM_INSETS = new Insets(0, 0, 5, 0);
    public static Insets TITLE_LABEL_INSETS = new Insets(0, 0, 5, 5);
    public static Insets RIGHT_INSETS_TWO_SPACES = new Insets(0, 0, 0, 5);
    public static Insets EVEN_INSETS = new Insets(5, 5, 5, 5);

    public GridBagConstraints xy(int x, int y) {
        GridBagConstraints result = new GridBagConstraints();
        result.gridx = x;
        result.gridy = y;
        return result;
    }

    public GridBagConstraints xywh(int x, int y, int width, int height) {
        GridBagConstraints result = this.xy(x, y);
        result.gridheight = height;
        result.gridwidth = width;
        return result;
    }

    public GridBagConstraints xyf(int x, int y, int fill) {
        return this.xyfi(x, y, fill, null);
    }

    public GridBagConstraints xyfi(int x, int y, int fill, Insets insets) {
        GridBagConstraints result = this.xy(x, y);
        result.fill = fill;
        if (insets != null) {
            result.insets = insets;
        }
        switch (result.fill) {
            case 0: {
                break;
            }
            case 1: {
                result.weighty = 1.0;
                result.weightx = 1.0;
                break;
            }
            case 3: {
                result.weighty = 1.0;
                break;
            }
            case 2: {
                result.weightx = 1.0;
                break;
            }
            default: {
                result.fill = 0;
            }
        }
        return result;
    }

    public GridBagConstraints xya(int x, int y, int anchor) {
        GridBagConstraints result = this.xy(x, y);
        result.anchor = anchor;
        return result;
    }

    public GridBagConstraints xyaf(int x, int y, int anchor, int fill) {
        return this.xyaf(x, y, anchor, fill, null);
    }

    public GridBagConstraints xyaf(int x, int y, int anchor, int fill, Insets insets) {
        GridBagConstraints result = this.xyfi(x, y, fill, insets);
        result.anchor = anchor;
        return result;
    }

    public GridBagConstraints title(int x, int y) {
        GridBagConstraints result = this.xy(x, y);
        result.anchor = 17;
        result.insets = TITLE_LABEL_INSETS;
        return result;
    }

    public GridBagConstraints label(int x, int y) {
        return this.label(x, y, RIGHT_INSETS);
    }

    public GridBagConstraints label(int x, int y, Insets insets) {
        GridBagConstraints result = this.xy(x, y);
        result.anchor = 17;
        result.insets = insets;
        return result;
    }

    public GridBagConstraints textField(int x, int y) {
        return this.xyf(x, y, 2);
    }

    public GridBagConstraints textField(int x, int y, Insets insets) {
        return this.xyfi(x, y, 2, insets);
    }
}

