/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class GuiStandardUtils {
    private GuiStandardUtils() {
    }

    public static JComponent attachBorder(JComponent c, Border border) {
        c.setBorder(border);
        return c;
    }

    public static JComponent attachBorder(JComponent c) {
        return GuiStandardUtils.attachDialogBorder(c);
    }

    public static JComponent attachDialogBorder(JComponent c) {
        if (c instanceof JTabbedPane) {
            c.setBorder(Borders.TABBED_DIALOG_BORDER);
        } else {
            c.setBorder(Borders.DIALOG_BORDER);
        }
        return c;
    }

    public static Border getStandardDialogBorder() {
        return Borders.DIALOG_BORDER;
    }

    public static Border createEvenlySpacedBorder(int spacePx) {
        return GuiStandardUtils.createEvenlySpacedBorder(Sizes.pixel((int)spacePx));
    }

    public static Border createEvenlySpacedBorder(ConstantSize space) {
        return Borders.createEmptyBorder((ConstantSize)space, (ConstantSize)space, (ConstantSize)space, (ConstantSize)space);
    }

    public static Border createLeftAndRightBorder(int spacePx) {
        return GuiStandardUtils.createLeftAndRightBorder(Sizes.pixel((int)spacePx));
    }

    public static Border createLeftAndRightBorder(ConstantSize space) {
        return Borders.createEmptyBorder((ConstantSize)Sizes.ZERO, (ConstantSize)space, (ConstantSize)Sizes.ZERO, (ConstantSize)space);
    }

    public static Border createTopAndBottomBorder(int spacePx) {
        return GuiStandardUtils.createTopAndBottomBorder(Sizes.pixel((int)spacePx));
    }

    public static Border createTopAndBottomBorder(ConstantSize space) {
        return Borders.createEmptyBorder((ConstantSize)space, (ConstantSize)Sizes.ZERO, (ConstantSize)space, (ConstantSize)Sizes.ZERO);
    }

    public static String createDialogTitle(String appName, String dialogName) {
        if (appName != null) {
            StringBuffer buf = new StringBuffer(appName);
            buf.append(": ");
            buf.append(dialogName);
            return buf.toString();
        }
        return dialogName;
    }

    public static JComponent createCommandButtonRow(JButton[] buttons) {
        return ButtonBarFactory.buildRightAlignedBar((JButton[])buttons);
    }

    public static JComponent createCommandButtonColumn(JButton[] buttons) {
        ButtonStackBuilder builder = new ButtonStackBuilder();
        for (int i = 0; i < buttons.length; ++i) {
            if (i > 0) {
                builder.addRelatedGap();
            }
            builder.addGridded((JComponent)buttons[i]);
        }
        return builder.getPanel();
    }

    public static void equalizeSizes(JComponent[] components) {
        Dimension targetSize = new Dimension(0, 0);
        for (int i = 0; i < components.length; ++i) {
            JComponent comp = components[i];
            Dimension compSize = comp.getPreferredSize();
            double width = Math.max(targetSize.getWidth(), compSize.getWidth());
            double height = Math.max(targetSize.getHeight(), compSize.getHeight());
            targetSize.setSize(width, height);
        }
        GuiStandardUtils.setSizes(components, targetSize);
    }

    private static void setSizes(JComponent[] components, Dimension dimension) {
        for (int i = 0; i < components.length; ++i) {
            JComponent comp = components[i];
            comp.setPreferredSize(dimension);
            comp.setMaximumSize(dimension);
        }
    }

    public static JTextArea createStandardTextArea(int rows, int columns) {
        JTextArea area = GuiStandardUtils.createStandardTextArea("");
        area.setRows(rows);
        area.setColumns(columns);
        return area;
    }

    public static JTextArea createStandardTextArea(String text) {
        JTextArea result = new JTextArea(text);
        return GuiStandardUtils.configureStandardTextArea(result);
    }

    public static JTextArea configureStandardTextArea(JTextArea textArea) {
        textArea.setEditable(false);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setMargin(new Insets(0, 5, 0, 5));
        return textArea;
    }

    public static JTextArea createStandardTextAreaHardNewLines(String text) {
        JTextArea result = new JTextArea(text);
        result.setEditable(false);
        result.setMargin(new Insets(0, 5, 0, 5));
        return result;
    }

    public static void truncateLabelIfLong(JLabel label) {
        String originalText = label.getText();
        if (originalText.length() > 35) {
            label.setToolTipText(originalText);
            String truncatedText = originalText.substring(0, 35) + "...";
            label.setText(truncatedText);
        }
    }

    public static JTextArea textAreaAsLabel(JTextArea textArea) {
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        GuiStandardUtils.textComponentAsLabel(textArea);
        return textArea;
    }

    public static JTextComponent textComponentAsLabel(JTextComponent textcomponent) {
        textcomponent.setEditable(false);
        textcomponent.setBackground((Color)UIManager.get("Label.background"));
        textcomponent.setForeground((Color)UIManager.get("Label.foreground"));
        textcomponent.setBorder(null);
        return textcomponent;
    }

    public static void createDebugBorder(JComponent c, Color color) {
        if (color == null) {
            color = Color.BLACK;
        }
        c.setBorder(BorderFactory.createLineBorder(color));
    }
}

