/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.springframework.richclient.image.EmptyIcon;

public class MenuElementUtils {
    private MenuElementUtils() {
    }

    private static boolean hasIcons(MenuElement menuElement) {
        MenuElement[] elements = menuElement.getSubElements();
        for (int i = 0; i < elements.length; ++i) {
            MenuElement element = elements[i];
            if (element instanceof JMenuItem && ((JMenuItem)element).getIcon() != null) {
                return true;
            }
            if (!(element instanceof JPopupMenu)) continue;
            return MenuElementUtils.hasIcons(element);
        }
        return false;
    }

    private static void fillInIcons(MenuElement menuElement) {
        MenuElement[] elements = menuElement.getSubElements();
        for (int i = 0; i < elements.length; ++i) {
            JMenuItem menu;
            MenuElement element = elements[i];
            if (element instanceof JMenuItem && (menu = (JMenuItem)element).getIcon() == null) {
                menu.setIcon(EmptyIcon.SMALL);
            }
            if (!(element instanceof JPopupMenu)) continue;
            MenuElementUtils.fillInIcons(element);
        }
    }

    public static void alignIcons(MenuElement menuElement) {
        if (MenuElementUtils.hasIcons(menuElement)) {
            MenuElementUtils.fillInIcons(menuElement);
        }
    }

    public static void showButtonPopupMenu(AbstractButton button, JPopupMenu popup) {
        if (!popup.isVisible()) {
            Dimension size = button.getSize();
            popup.show(button, 0, size.height);
        }
    }
}

