/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import java.awt.Component;
import java.awt.FlowLayout;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.binding.form.FormModel;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.config.ApplicationObjectConfigurer;
import org.springframework.richclient.application.support.DefaultApplicationServices;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.config.CommandButtonConfigurer;
import org.springframework.richclient.command.config.CommandConfigurer;
import org.springframework.richclient.command.config.CommandFaceDescriptor;
import org.springframework.richclient.command.support.DataEditorWidgetViewCommand;
import org.springframework.richclient.exceptionhandling.EmailNotifierErrorReporter;
import org.springframework.richclient.factory.DefaultButtonFactory;
import org.springframework.richclient.image.IconSource;
import org.springframework.richclient.util.PublicCloneable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RcpSupport {
    public static final String ERROR_KEY = "error";
    public static final String LABEL = "label";
    public static final String HEADER = "header";
    public static final String TEXT = "text";
    public static final String TITLE = "title";
    public static final String MESSAGE = "message";
    public static final String DETAIL = "detail";
    public static final String CAPTION = "caption";
    public static final String ICON = "icon";
    public static final int YES_OPTION = 0;
    public static final int OK_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private static MessageSourceAccessor messageSourceAccessor;
    private static CommandConfigurer commandConfigurer;
    private static ApplicationContext applicationContext;
    private static ApplicationObjectConfigurer applicationObjectConfigurer;
    private static IconSource iconSource;
    private static Map<Integer, Object[]> optionsMap;

    public static String[] getMessageKeys(String id, String name, String type) {
        boolean idNotEmpty = id != null && !id.trim().equals("");
        String[] keys = new String[idNotEmpty ? 3 : 2];
        int i = 0;
        if (idNotEmpty) {
            keys[i++] = id + "." + name + "." + type;
        }
        keys[i++] = name + "." + type;
        keys[i] = name;
        return keys;
    }

    public static String getMessage(String id, String name, String type) {
        String[] messageKeys = RcpSupport.getMessageKeys(id, name, type);
        if (messageSourceAccessor == null) {
            messageSourceAccessor = (MessageSourceAccessor)ApplicationServicesLocator.services().getService(MessageSourceAccessor.class);
        }
        return messageSourceAccessor.getMessage((MessageSourceResolvable)new DefaultMessageSourceResolvable(messageKeys, null, messageKeys[messageKeys.length - 1]));
    }

    public static String getMessage(MessageSourceResolvable msr) {
        if (messageSourceAccessor == null) {
            messageSourceAccessor = (MessageSourceAccessor)ApplicationServicesLocator.services().getService(MessageSourceAccessor.class);
        }
        return messageSourceAccessor.getMessage(msr);
    }

    public static String getMessage(String id) {
        if (messageSourceAccessor == null) {
            messageSourceAccessor = (MessageSourceAccessor)ApplicationServicesLocator.services().getService(MessageSourceAccessor.class);
        }
        return messageSourceAccessor.getMessage(id, "");
    }

    public static String getMessage(String id, String name, String type, Object[] params) {
        String message = RcpSupport.getMessage(id, name, type);
        if (params != null) {
            return MessageFormat.format(message, params);
        }
        return message;
    }

    public static void configure(AbstractCommand command) {
        if (commandConfigurer == null) {
            commandConfigurer = (CommandConfigurer)ApplicationServicesLocator.services().getService(CommandConfigurer.class);
        }
        commandConfigurer.configure(command);
    }

    public static void configure(Object object, String id) {
        if (applicationObjectConfigurer == null) {
            applicationObjectConfigurer = (ApplicationObjectConfigurer)ApplicationServicesLocator.services().getService(ApplicationObjectConfigurer.class);
        }
        applicationObjectConfigurer.configure(object, id);
    }

    public static Icon getIcon(String key) {
        if (iconSource == null) {
            iconSource = (IconSource)ApplicationServicesLocator.services().getService(IconSource.class);
        }
        return iconSource.getIcon(key);
    }

    public static <T> T getBean(String id) {
        if (applicationContext == null) {
            applicationContext = ((DefaultApplicationServices)ApplicationServicesLocator.services()).getApplicationContext();
        }
        return (T)applicationContext.getBean(id);
    }

    public static <T> T getCommand(String commandId) {
        return (T)Application.instance().getActiveWindow().getCommandManager().getCommand(commandId);
    }

    private static String escapeXml(String input) {
        return input == null ? "" : input.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static String getDetailsAsHTML(String title, Level level, Throwable e) {
        if (e != null) {
            StringBuffer html = new StringBuffer("<html>");
            html.append("<h2>" + RcpSupport.escapeXml(title) + "</h2>");
            html.append("<HR size='1' noshade>");
            html.append("<div></div>");
            html.append("<b>Message:</b>");
            html.append("<pre>");
            html.append("    " + RcpSupport.escapeXml(e.toString()));
            html.append("</pre>");
            html.append("<b>Level:</b>");
            html.append("<pre>");
            html.append("    " + level);
            html.append("</pre>");
            html.append("<b>Stack Trace:</b>");
            html.append("<pre>");
            for (StackTraceElement el : e.getStackTrace()) {
                html.append("    " + el.toString().replace("<init>", "&lt;init&gt;") + "\n");
            }
            if (e.getCause() != null) {
                html.append("</pre>");
                html.append("<b>Cause:</b>");
                html.append("<pre>");
                html.append(e.getCause().getMessage());
                html.append("</pre><pre>");
                for (StackTraceElement el : e.getCause().getStackTrace()) {
                    html.append("    " + el.toString().replace("<init>", "&lt;init&gt;") + "\n");
                }
            }
            html.append("</pre></html>");
            return html.toString();
        }
        return null;
    }

    public static void handleException(Throwable t) {
        Application.instance().getLifecycleAdvisor().getRegisterableExceptionHandler().uncaughtException(Thread.currentThread(), t);
    }

    public static void showErrorDialog(Throwable t) {
        String title = RcpSupport.getMessage(null, ERROR_KEY, TITLE);
        String shortMessage = RcpSupport.getMessage(t.getClass().getName() + "." + MESSAGE);
        if ((shortMessage == null || "".equals(shortMessage)) && ((shortMessage = t.getMessage()) == null || "".equals(shortMessage))) {
            shortMessage = RcpSupport.getMessage(null, ERROR_KEY, MESSAGE);
        }
        RcpSupport.showErrorDialog(null, new ErrorInfo(title, shortMessage, RcpSupport.getDetailsAsHTML(title, Level.SEVERE, t), null, t, Level.SEVERE, null));
    }

    public static void showSQLExceptionErrorDialog(SQLException sqlException) {
        String title = RcpSupport.getMessage(null, ERROR_KEY, TITLE);
        String shortMessage = RcpSupport.getMessage(sqlException.getClass().getName() + "." + sqlException.getErrorCode() + "." + MESSAGE);
        if (!StringUtils.hasText((String)shortMessage)) {
            shortMessage = RcpSupport.getMessage(sqlException.getClass().getName() + "." + MESSAGE);
            shortMessage = shortMessage + "\nSQL error " + sqlException.getErrorCode();
        }
        if ((shortMessage == null || "".equals(shortMessage)) && ((shortMessage = sqlException.getMessage()) == null || "".equals(shortMessage))) {
            shortMessage = RcpSupport.getMessage(null, ERROR_KEY, MESSAGE);
        }
        RcpSupport.showErrorDialog(null, new ErrorInfo(title, shortMessage, RcpSupport.getDetailsAsHTML(title, Level.SEVERE, sqlException), null, (Throwable)sqlException, Level.SEVERE, null));
    }

    public static void showErrorDialogResolveMessages(String id) {
        String title = RcpSupport.getMessage(id, ERROR_KEY, TITLE);
        String message = RcpSupport.getMessage(id, ERROR_KEY, MESSAGE);
        String detail = RcpSupport.getMessage(id, ERROR_KEY, DETAIL);
        detail = detail == ERROR_KEY ? "" : detail;
        RcpSupport.showErrorDialog(title, message, detail);
    }

    public static void showErrorDialog(String message) {
        RcpSupport.showErrorDialog(message, (String)null);
    }

    public static void showErrorDialog(String message, String detail) {
        RcpSupport.showErrorDialog(RcpSupport.getMessage(null, ERROR_KEY, TITLE), message, detail);
    }

    public static void showErrorDialog(String id, Throwable cause) {
        String title = RcpSupport.getMessage(id, ERROR_KEY, TITLE);
        String message = RcpSupport.getMessage(id, ERROR_KEY, MESSAGE);
        RcpSupport.showErrorDialog(null, new ErrorInfo(title, message, RcpSupport.getDetailsAsHTML(title, Level.SEVERE, cause), null, cause, Level.SEVERE, null));
    }

    public static void showErrorDialog(String title, String message, String detail) {
        RcpSupport.showErrorDialog(null, new ErrorInfo(title, message, detail, null, null, Level.SEVERE, null));
    }

    public static void showErrorDialog(Component parent, ErrorInfo errorInfo) {
        ApplicationWindow activeWindow;
        if (parent == null && Application.isLoaded() && (activeWindow = Application.instance().getActiveWindow()) != null) {
            parent = activeWindow.getControl();
        }
        JXErrorPane pane = new JXErrorPane();
        pane.setErrorInfo(errorInfo);
        pane.setErrorReporter((ErrorReporter)new EmailNotifierErrorReporter());
        JXErrorPane.showDialog((Component)parent, (JXErrorPane)pane);
    }

    public static int showWarningDialog(String id, int optionType) {
        return RcpSupport.showWarningDialog((Component)Application.instance().getActiveWindow().getControl(), id, optionType);
    }

    public static int showWarningDialog(Component parent, String id, int optionType) {
        return RcpSupport.showWarningDialog(parent, id, null, optionType);
    }

    public static int showWarningDialog(Component parent, String id, Object[] parameters, int optionType) {
        String message = RcpSupport.getMessage(null, id, TEXT, parameters);
        String title = RcpSupport.getMessage(null, id, TITLE);
        return JOptionPane.showConfirmDialog(parent, message, title, optionType, 2);
    }

    public static int showWarningDialog(String id, int optionType, int initialValue) {
        return RcpSupport.showWarningDialog(Application.instance().getActiveWindow().getControl(), id, null, optionType, initialValue);
    }

    public static int showWarningDialog(Component parent, String id, Object[] parameters, int optionType, int initialValue) {
        Object[] options = optionsMap.get(optionType);
        String message = RcpSupport.getMessage(null, id, TEXT, parameters);
        String title = RcpSupport.getMessage(null, id, TITLE);
        if (optionType == 2 && initialValue == 2) {
            initialValue = 1;
        }
        if (initialValue >= options.length) {
            throw new IllegalArgumentException("De waarde van het argument initialValue is niet gekend door het gekozen optionType");
        }
        return JOptionPane.showOptionDialog(parent, message, title, optionType, 2, null, options, options[initialValue]);
    }

    public static ActionCommand createDummyCommand(String id, final String msg) {
        ActionCommand newCommand = new ActionCommand(id){

            protected void doExecuteCommand() {
                System.out.println(msg);
            }
        };
        ((CommandConfigurer)ApplicationServicesLocator.services().getService(CommandConfigurer.class)).configure(newCommand);
        return newCommand;
    }

    public static void showWarningDialog(String id) {
        RcpSupport.showWarningDialog(Application.instance().getActiveWindow().getControl(), id);
    }

    public static void showWarningDialog(Component parent, String id) {
        RcpSupport.showWarningDialog(parent, id, null);
    }

    public static void showWarningDialog(Component parent, String id, Object[] parameters) {
        String message = RcpSupport.getMessage(null, id, TEXT, parameters);
        String title = RcpSupport.getMessage(null, id, TITLE);
        JOptionPane.showMessageDialog(parent, message, title, 2);
    }

    public static int showConfirmationDialog(String id) {
        return RcpSupport.showConfirmationDialog(Application.instance().getActiveWindow().getControl(), id);
    }

    public static int showConfirmationDialog(Component parent, String id) {
        return RcpSupport.showConfirmationDialog(parent, id, null);
    }

    public static int showConfirmationDialog(Component parent, String id, Object[] parameters) {
        return RcpSupport.showConfirmationDialog(parent, id, parameters, 1);
    }

    public static int showConfirmationDialog(Component parent, String id, Object[] parameters, int optionType) {
        String message = RcpSupport.getMessage(null, id, TEXT, parameters);
        String title = RcpSupport.getMessage(null, id, TITLE);
        return JOptionPane.showConfirmDialog(parent, message, title, optionType);
    }

    public static void showMessageDialog(Component parent, String id, Object[] parameters, int optionType) {
        String message = RcpSupport.getMessage(null, id, TEXT, parameters);
        String title = RcpSupport.getMessage(null, id, TITLE);
        JOptionPane.showMessageDialog(parent, message, title, optionType);
    }

    public static void mapObjectOnFormModel(FormModel formModel, Object objectToMap) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(objectToMap);
        for (String fieldName : formModel.getFieldNames()) {
            try {
                formModel.getValueModel(fieldName).setValue(beanWrapper.getPropertyValue(fieldName));
            }
            catch (BeansException be) {}
        }
    }

    private static Object clonePublicCloneableObject(Object value) {
        try {
            return ((PublicCloneable)value).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone not support for object " + value.getClass());
        }
    }

    public static Object getClone(Object value) {
        if (value instanceof PublicCloneable) {
            return RcpSupport.clonePublicCloneableObject(value);
        }
        if (value instanceof Collection) {
            Collection valueCollection = (Collection)value;
            Collection clonedCollection = valueCollection instanceof List ? (valueCollection instanceof LinkedList ? new LinkedList() : new ArrayList()) : (valueCollection instanceof Set ? (valueCollection instanceof SortedSet ? new TreeSet() : (valueCollection instanceof LinkedHashSet ? new LinkedHashSet() : new HashSet())) : (Collection)BeanUtils.instantiateClass(value.getClass()));
            for (Object valueElement : valueCollection) {
                if (valueElement instanceof PublicCloneable) {
                    clonedCollection.add(RcpSupport.clonePublicCloneableObject(valueElement));
                    continue;
                }
                clonedCollection.add(valueElement);
            }
            return clonedCollection;
        }
        if (value instanceof Map) {
            Map valueMap = (Map)value;
            TreeMap clonedMap = valueMap instanceof SortedMap ? new TreeMap() : (valueMap instanceof LinkedHashMap ? new LinkedHashMap() : new HashMap());
            for (Map.Entry entry : valueMap.entrySet()) {
                if (entry.getValue() instanceof PublicCloneable) {
                    clonedMap.put(entry.getKey(), RcpSupport.clonePublicCloneableObject(entry.getValue()));
                    continue;
                }
                clonedMap.put(entry.getKey(), entry.getValue());
            }
            return clonedMap;
        }
        return value;
    }

    public static JPanel createIconButtonPanel(List<? extends AbstractCommand> commands) {
        JPanel buttons = new JPanel(new FlowLayout(2));
        DefaultButtonFactory factory = new DefaultButtonFactory();
        CommandButtonConfigurer configurer = new CommandButtonConfigurer(){

            public void configure(AbstractButton button, AbstractCommand command, CommandFaceDescriptor faceDescriptor) {
                faceDescriptor.configureIcon(button);
                button.setToolTipText(faceDescriptor.getCaption());
            }
        };
        for (AbstractCommand abstractCommand : commands) {
            buttons.add(abstractCommand.createButton(factory, configurer));
        }
        return buttons;
    }

    public static JComponent createDummyPanel(String vakske) {
        JPanel dummy = new JPanel();
        dummy.add(new JLabel(vakske));
        return dummy;
    }

    public static void executeViewDataEditorCommand(DataEditorWidgetViewCommand command, Object filter, Object defaultSelectedObject) {
        Assert.notNull((Object)command, (String)"Command mag niet null zijn!");
        HashMap<String, Object> dataEditorParameters = new HashMap<String, Object>(2);
        dataEditorParameters.put("filter", filter);
        dataEditorParameters.put("defaultSelectedObject", defaultSelectedObject);
        HashMap<String, HashMap<String, Object>> commandParameters = new HashMap<String, HashMap<String, Object>>(1);
        commandParameters.put("dataEditorParameters", dataEditorParameters);
        command.execute(commandParameters);
    }

    static {
        optionsMap = new HashMap<Integer, Object[]>();
        String yes = RcpSupport.getMessage(null, "OptionPane.yesButtonText", LABEL);
        String no = RcpSupport.getMessage(null, "OptionPane.noButtonText", LABEL);
        String cancel = RcpSupport.getMessage(null, "OptionPane.cancelButtonText", LABEL);
        String ok = RcpSupport.getMessage(null, "OptionPane.okButtonText", LABEL);
        optionsMap.put(-1, new Object[]{ok});
        optionsMap.put(0, new Object[]{yes, no});
        optionsMap.put(1, new Object[]{yes, no, cancel});
        optionsMap.put(2, new Object[]{ok, cancel});
    }
}

