/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import org.springframework.richclient.util.Assert;

public class SeparatorUtils {
    private SeparatorUtils() {
    }

    public static void consolidateSeparators(JToolBar toolBar) {
        Assert.notNull((Object)toolBar, (String)"toolBar cannot be null");
        SeparatorUtils.consolidateSeparators(toolBar.getComponents());
    }

    public static void consolidateSeparators(JPopupMenu popupMenu) {
        Assert.notNull((Object)popupMenu, (String)"popupMenu cannot be null");
        SeparatorUtils.consolidateSeparators(popupMenu.getComponents());
    }

    private static void consolidateSeparators(Component[] menuComponents) {
        Assert.notNull((Object)menuComponents, (String)"menuComponents cannot be null");
        Component previousVisibleComponent = null;
        boolean everythingInvisibleSoFar = true;
        for (int i = 0; i < menuComponents.length; ++i) {
            Component menuComponent = menuComponents[i];
            if (menuComponent instanceof JSeparator) {
                menuComponent.setVisible(true);
            }
            if (menuComponent instanceof JSeparator && everythingInvisibleSoFar) {
                menuComponent.setVisible(false);
            } else if (menuComponent instanceof JSeparator && previousVisibleComponent instanceof JSeparator) {
                previousVisibleComponent.setVisible(false);
            }
            if (menuComponent instanceof JSeparator) {
                previousVisibleComponent = menuComponent;
            } else if (menuComponent.isVisible()) {
                everythingInvisibleSoFar = false;
                previousVisibleComponent = menuComponent;
            }
            if (!(menuComponent instanceof JMenu)) continue;
            SeparatorUtils.consolidateSeparators((JMenu)menuComponent);
        }
        if (previousVisibleComponent instanceof JSeparator) {
            previousVisibleComponent.setVisible(false);
        }
    }

    public static void consolidateSeparators(JMenu menu) {
        Assert.notNull((Object)menu, (String)"menu cannot be null");
        Component previousVisibleComponent = null;
        boolean everythingInvisibleSoFar = true;
        for (int j = 0; j < menu.getMenuComponentCount(); ++j) {
            Component menuComponent = menu.getMenuComponent(j);
            if (menuComponent instanceof JSeparator) {
                menuComponent.setVisible(true);
            }
            if (menuComponent instanceof JSeparator && everythingInvisibleSoFar) {
                menuComponent.setVisible(false);
            } else if (menuComponent instanceof JSeparator && previousVisibleComponent instanceof JSeparator) {
                previousVisibleComponent.setVisible(false);
            }
            if (menuComponent instanceof JSeparator) {
                previousVisibleComponent = menuComponent;
            } else if (menuComponent.isVisible()) {
                everythingInvisibleSoFar = false;
                previousVisibleComponent = menuComponent;
            }
            if (!(menuComponent instanceof JMenu)) continue;
            SeparatorUtils.consolidateSeparators((JMenu)menuComponent);
        }
        if (previousVisibleComponent instanceof JSeparator) {
            previousVisibleComponent.setVisible(false);
        }
    }

    public static void consolidateSeparators(JMenuBar menuBar) {
        Assert.notNull((Object)menuBar, (String)"menu bar cannot be null");
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            SeparatorUtils.consolidateSeparators(menuBar.getMenu(i));
        }
    }
}

