/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import EDU.oswego.cs.dl.util.concurrent.TimedCallable;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public abstract class SwingWorker
extends FutureResult
implements Runnable {
    protected Thread thread;

    protected abstract Object construct() throws Exception;

    protected void finished() {
    }

    protected Object getFinishedResult() {
        try {
            return this.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted exception should not have occured; are you calling from finished()?");
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    protected Throwable getTargetException() {
        InvocationTargetException e = this.getException();
        if (e != null) {
            return e.getTargetException();
        }
        return e;
    }

    public long getTimeout() {
        return 0L;
    }

    public void run() {
        Callable function = new Callable(){

            public Object call() throws Exception {
                return SwingWorker.this.construct();
            }
        };
        Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        long msecs = this.getTimeout();
        if (msecs != 0L) {
            function = new TimedCallable(function, msecs);
        }
        this.setter(function).run();
        SwingUtilities.invokeLater(doFinished);
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
        }
        this.thread.start();
    }

    public synchronized void interrupt() {
        if (this.thread != null) {
            try {
                this.thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setException(new InterruptedException());
    }

    public synchronized void clear() {
        super.clear();
        this.thread = null;
    }
}

