/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.dialog.TitlePane;
import org.springframework.richclient.form.ValidationResultsReporter;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.richclient.util.RcpSupport;
import org.springframework.richclient.widget.AbstractWidget;
import org.springframework.richclient.widget.TitledWidget;

public abstract class AbstractTitledWidget
extends AbstractWidget
implements TitledWidget {
    private Message description = new DefaultMessage(RcpSupport.getMessage("titledWidget", "defaultMessage", "text"), Severity.INFO);
    private TitlePane titlePane = new TitlePane(1);
    private JComponent component;
    private String id;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setBeanName(String beanName) {
        this.setId(beanName);
    }

    public boolean isEnabled() {
        return false;
    }

    public void setEnabled(boolean enabled) {
    }

    public void setTitle(String title) {
        this.titlePane.setTitle(title);
    }

    public void setImage(Image image) {
        this.titlePane.setImage(image);
    }

    public void setMessage(Message message) {
        if (message != null) {
            this.titlePane.setMessage(message);
        } else {
            this.titlePane.setMessage(this.getDescription());
        }
    }

    public ValidationResultsReporter newSingleLineResultsReporter(Messagable messagable) {
        return null;
    }

    protected Message getDescription() {
        return this.description;
    }

    public void setDescription(String longDescription) {
        this.description = new DefaultMessage(longDescription);
        this.setMessage(this.description);
    }

    public void setCaption(String shortDescription) {
    }

    public final JComponent getComponent() {
        if (this.component == null) {
            this.component = this.createComponent();
        }
        return this.component;
    }

    private JComponent createComponent() {
        JPanel titlePaneContainer = new JPanel(new BorderLayout());
        titlePaneContainer.add(this.titlePane.getControl());
        titlePaneContainer.add((Component)new JSeparator(), "South");
        JPanel pageControl = new JPanel(new BorderLayout());
        pageControl.add((Component)titlePaneContainer, "North");
        JComponent content = this.createWidgetContent();
        GuiStandardUtils.attachDialogBorder(content);
        pageControl.add(content);
        return pageControl;
    }

    public abstract JComponent createWidgetContent();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.titlePane.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String txt, PropertyChangeListener listener) {
        this.titlePane.addPropertyChangeListener(txt, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.titlePane.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String txt, PropertyChangeListener listener) {
        this.titlePane.removePropertyChangeListener(txt, listener);
    }
}

