/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import org.springframework.core.io.Resource;
import org.springframework.richclient.widget.AbstractWidget;
import org.springframework.util.FileCopyUtils;

public class HTMLViewWidget
extends AbstractWidget {
    private JTextPane textPane = new JTextPane();
    private JComponent mainComponent;
    private boolean hasContent;

    public HTMLViewWidget() {
        this(false);
    }

    public HTMLViewWidget(boolean readOnly) {
        this.textPane.setEditorKit(new HTMLEditorKit());
        this.textPane.setEditable(!readOnly);
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setPreferredSize(new Dimension(250, 155));
        this.hasContent = true;
        this.mainComponent = scrollPane;
    }

    public HTMLViewWidget(Resource resource) {
        this();
        this.setContent(resource);
    }

    public HTMLViewWidget(Resource resource, boolean readOnly) {
        this(readOnly);
        this.setContent(resource);
    }

    public HTMLViewWidget(String htmlText) {
        this();
        this.setContent(htmlText);
    }

    public HTMLViewWidget(String htmlText, boolean readOnly) {
        this(readOnly);
        this.setContent(htmlText);
    }

    public void setContent(Resource resource) {
        String text = null;
        try {
            if (resource != null && resource.exists()) {
                text = FileCopyUtils.copyToString((Reader)new BufferedReader(new InputStreamReader(resource.getInputStream())));
            }
        }
        catch (IOException e) {
            this.logger.warn((Object)("Error reading resource: " + resource), (Throwable)e);
            throw new RuntimeException("Error reading resource " + resource, e);
        }
        finally {
            this.setContent(text);
        }
    }

    public void setContent(String htmlText) {
        this.textPane.setText(htmlText);
        this.hasContent = htmlText != null && htmlText.length() > 0;
    }

    public JComponent getComponent() {
        return this.hasContent ? this.mainComponent : new JPanel();
    }
}

