/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget;

import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.richclient.util.PopupMenuMouseListener;
import org.springframework.richclient.util.RcpSupport;
import org.springframework.richclient.widget.AbstractWidget;
import org.springframework.richclient.widget.HTMLViewWidget;
import org.springframework.richclient.widget.ImageViewWidget;

public class ScreenSimulationWidget
extends AbstractWidget {
    JTabbedPane mainComponent = new JTabbedPane(1, 1);
    private static Log log = LogFactory.getLog(ScreenSimulationWidget.class);

    public ScreenSimulationWidget(Resource explanationPath) {
        this(explanationPath, null);
    }

    public ScreenSimulationWidget(Resource explanationPath, Resource imagePath) {
        this(explanationPath, imagePath, null);
    }

    public ScreenSimulationWidget(Resource explanationPath, Resource imagePath, JPopupMenu popup) {
        JComponent imageArea = this.createImagePanel(imagePath);
        if (imageArea != null) {
            String screenLabel = RcpSupport.getMessage("simulation", "screen", "label");
            this.mainComponent.addTab(screenLabel, imageArea);
        } else {
            log.warn((Object)("Image not found at " + imagePath));
        }
        JComponent explanationArea = this.createTextPanel(explanationPath);
        if (explanationArea != null) {
            String explanationLabel = RcpSupport.getMessage("simulation", "explanation", "label");
            this.mainComponent.addTab(explanationLabel, explanationArea);
        } else {
            log.warn((Object)("Explanation html not found at " + explanationPath));
        }
        if (popup != null) {
            this.mainComponent.addMouseListener(new PopupMenuMouseListener(popup));
        }
    }

    private JComponent createTextPanel(Resource textResource) {
        HTMLViewWidget hw = new HTMLViewWidget(textResource);
        return hw.getComponent();
    }

    private JComponent createImagePanel(Resource imageResource) {
        ImageViewWidget hw = new ImageViewWidget(imageResource);
        return hw.getComponent();
    }

    public JComponent getComponent() {
        return this.mainComponent;
    }
}

