/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.springframework.richclient.application.support.AbstractView;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.widget.Widget;

public class WidgetView
extends AbstractView {
    private Widget widget;

    public WidgetView() {
    }

    public WidgetView(Widget widget) {
        this.setWidget(widget);
    }

    public void setWidget(Widget widget) {
        this.widget = widget;
    }

    public Widget getWidget() {
        return this.widget;
    }

    protected JComponent createControl() {
        JComponent widgetComponent = this.getWidget().getComponent();
        JPanel viewPanel = new JPanel(new BorderLayout());
        viewPanel.add((Component)widgetComponent, "Center");
        Widget widget = this.getWidget();
        List<? extends AbstractCommand> widgetCommands = widget.getCommands();
        if (widgetCommands != null) {
            JComponent widgetButtonBar = CommandGroup.createCommandGroup(widgetCommands).createButtonBar(ColumnSpec.decode((String)"fill:pref:nogrow"), RowSpec.decode((String)"fill:default:nogrow"), null);
            JPanel buttonPanel = new JPanel(new FlowLayout(0));
            buttonPanel.add(widgetButtonBar);
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            viewPanel.add((Component)buttonPanel, "South");
        }
        return viewPanel;
    }

    public boolean canClose() {
        return this.getWidget().canClose();
    }

    public void componentFocusGained() {
        this.getWidget().onAboutToShow();
    }

    public void componentFocusLost() {
        this.getWidget().onAboutToHide();
    }
}

