/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget.editor;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.springframework.binding.form.NewFormObjectAware;
import org.springframework.binding.form.ValidatingFormModel;
import org.springframework.binding.validation.support.DefaultValidationResultsModel;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.DefaultButtonFocusListener;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.ActionCommandInterceptor;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.command.SplitPaneExpansionToggleCommand;
import org.springframework.richclient.command.config.CommandConfigurer;
import org.springframework.richclient.components.Focussable;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.form.AbstractForm;
import org.springframework.richclient.form.FilterForm;
import org.springframework.richclient.form.FormGuard;
import org.springframework.richclient.form.SimpleValidationResultsReporter;
import org.springframework.richclient.form.ValidationResultsReporter;
import org.springframework.richclient.util.RcpSupport;
import org.springframework.richclient.widget.AbstractTitledWidget;
import org.springframework.richclient.widget.SelectionWidget;
import org.springframework.richclient.widget.TitledWidget;
import org.springframework.richclient.widget.Widget;
import org.springframework.richclient.widget.editor.provider.DataProviderEventSource;
import org.springframework.richclient.widget.editor.provider.DataProviderListener;
import org.springframework.richclient.widget.table.TableWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataEditorWidget
extends AbstractTitledWidget
implements TitledWidget,
SelectionWidget {
    private static final Log log = LogFactory.getLog(AbstractDataEditorWidget.class);
    private static final String QUICKADD = "quickAdd";
    protected static final String UPDATE_COMMAND_ID = "update";
    protected static final String CREATE_COMMAND_ID = "create";
    private static final String TOGGLE_DETAIL_COMMAND_ID = "opendetail";
    private static final String REMOVE_CONTINUE_AFTER_ERROR = "remove.continue_after_error";
    private static final String REMOVE_CONFIRMATION_ID = "remove.confirmation";
    private static final String DBLCLICKSELECTS = "dblclick_for_edit";
    public static final String UNSAVEDCHANGES_WARNING_ID = "unsavedchanges.warning";
    public static final String UNSAVEDCHANGES_UNCOMMITTABLE_WARNING_ID = "unsavedchanges.uncommittable.warning";
    public static final RowSpec FILL_ROW_SPEC = new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
    public static final ColumnSpec FILL_NOGROW_COLUMN_SPEC = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 0.0);
    public static final ColumnSpec FILL_COLUMN_SPEC = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
    public static final boolean ON = true;
    public static final boolean OFF = false;
    private boolean selectMode = false;
    private boolean multipleSelectionInSelectMode = false;
    private String searchString;
    private Object selectedRowObject;
    private final CellConstraints cc = new CellConstraints();
    private SplitPaneExpansionToggleCommand toggleDetailCommand;
    private SplitPaneExpansionToggleCommand toggleFilterCommand;
    private ActionCommand editRowCommand;
    private ActionCommand addRowCommand;
    private ActionCommand cloneRowCommand;
    private ActionCommand removeRowsCommand;
    private ActionCommand executeFilterCommand;
    private ActionCommand refreshCommand;
    private ActionCommand clearFilterCommand;
    private ActionCommand emptyFilterCommand;
    private ActionCommand selectionCommand;
    private ActionCommand printCommand;
    private ActionCommand updateCommand;
    private ActionCommand createRowCommand;
    private CardLayout saveUpdateSwitcher;
    private JPanel saveUpdatePanel;
    private JTextField textFilterField;
    private Map dataProviderSources = null;
    private final CommandConfigurer commandConfigurer = (CommandConfigurer)ApplicationServicesLocator.services().getService(CommandConfigurer.class);
    protected Observer tableSelectionObserver = this.createListSelectionObserver();
    private JCheckBox quickAddCheckBox;
    private ActionCommand copySelectedRowsCommand;

    protected Observer createListSelectionObserver() {
        return new ListSelectionObserver();
    }

    public void setSelectMode(boolean selectMode) {
        this.selectMode = selectMode;
    }

    public boolean isSelectMode() {
        return this.selectMode;
    }

    public void setSearchString(String queryString) {
        this.searchString = queryString;
        if (this.textFilterField != null) {
            this.textFilterField.setText(this.searchString);
        }
    }

    public String getSearchString() {
        return this.searchString;
    }

    public Object getSelectedRowObject() {
        return this.selectedRowObject;
    }

    public void setSelectedRowObject(Object selectedObject) {
        this.getTableWidget().selectRowObject(selectedObject, null);
    }

    public abstract Object setSelectedSearch(Object var1);

    @Override
    public JComponent createWidgetContent() {
        return this.createDataEditorWidget();
    }

    protected final JComponent createDataEditorWidget() {
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        if (this.isSelectMode()) {
            DefaultButtonFocusListener.setDefaultButton(this.getTableWidget().getComponent(), this.getSelectCommand());
            this.getTableWidget().getTable().getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
        }
        if (this.isSelectMode() && this.selectedRowObject == null) {
            splitPane.setDividerLocation(Integer.MAX_VALUE);
            this.toggleDetailCommand = new SplitPaneExpansionToggleCommand(TOGGLE_DETAIL_COMMAND_ID, splitPane, true);
        } else {
            splitPane.setDividerLocation(-1);
            this.toggleDetailCommand = new SplitPaneExpansionToggleCommand(TOGGLE_DETAIL_COMMAND_ID, splitPane, false);
        }
        splitPane.setLastDividerLocation(-1);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(this.getTableResizeWeight());
        splitPane.setLeftComponent(this.getTableFilterPanel());
        splitPane.setRightComponent(this.getDetailPanel());
        this.getDetailForm().setEnabled(this.getTableWidget().hasSelection());
        this.createAddRowCommand();
        this.createRemoveRowCommand();
        this.createCloneRowCommand();
        return splitPane;
    }

    protected double getTableResizeWeight() {
        return 0.75;
    }

    private JComponent getControlPanel() {
        AbstractCommand localToggleDetailCommand = this.getToggleDetailCommand();
        AbstractCommand helpCommand = this.getHelpCommand();
        AbstractCommand[] commands = this.getControlCommands();
        ColumnSpec[] columnSpecs = new ColumnSpec[1 + (commands.length + 1) * 2];
        columnSpecs[0] = FILL_NOGROW_COLUMN_SPEC;
        columnSpecs[1] = FormFactory.UNRELATED_GAP_COLSPEC;
        columnSpecs[2] = FILL_NOGROW_COLUMN_SPEC;
        columnSpecs[3] = FILL_COLUMN_SPEC;
        for (int i = 0; i < commands.length; ++i) {
            columnSpecs[4 + i * 2] = FILL_NOGROW_COLUMN_SPEC;
            if (i == commands.length - 1) continue;
            columnSpecs[5 + i * 2] = FormFactory.UNRELATED_GAP_COLSPEC;
        }
        RowSpec[] rowSpecs = new RowSpec[]{FILL_ROW_SPEC};
        FormLayout formLayout = new FormLayout(columnSpecs, rowSpecs);
        JPanel buttonPanel = new JPanel((LayoutManager)formLayout);
        buttonPanel.add((Component)localToggleDetailCommand.createButton(), this.cc.xy(1, 1));
        buttonPanel.add((Component)helpCommand.createButton(), this.cc.xy(3, 1));
        for (int i = 0; i < commands.length; ++i) {
            buttonPanel.add((Component)commands[i].createButton(), this.cc.xy(5 + i * 2, 1));
        }
        return buttonPanel;
    }

    public List<AbstractCommand> getCommands() {
        return Arrays.asList(this.getToggleDetailCommand());
    }

    protected JComponent getDetailPanel() {
        ColumnSpec[] columnSpecs = new ColumnSpec[]{FILL_COLUMN_SPEC};
        RowSpec[] rowSpecs = new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FILL_ROW_SPEC};
        JPanel detailPanel = new JPanel((LayoutManager)new FormLayout(columnSpecs, rowSpecs));
        AbstractForm detailForm = this.getDetailForm();
        this.newSingleLineResultsReporter(this);
        detailPanel.add((Component)this.getDetailControlPanel(), this.cc.xy(1, 2));
        detailPanel.add((Component)detailForm.getControl(), this.cc.xy(1, 4));
        if (!this.isAddRowSupported() && !this.isUpdateRowSupported()) {
            detailForm.getFormModel().setReadOnly(true);
        }
        return detailPanel;
    }

    private JComponent getDetailControlPanel() {
        ColumnSpec[] columnSpecs = new ColumnSpec[]{FILL_NOGROW_COLUMN_SPEC, FILL_COLUMN_SPEC, FILL_NOGROW_COLUMN_SPEC, FILL_COLUMN_SPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0)};
        RowSpec[] rowSpecs = new RowSpec[]{FILL_ROW_SPEC};
        FormLayout formLayout = new FormLayout(columnSpecs, rowSpecs);
        formLayout.setColumnGroups((int[][])new int[][]{{2, 4}});
        JPanel buttonPanel = new JPanel((LayoutManager)formLayout);
        JComponent editButtons = this.getEditButtons();
        JComponent tableButtonBar = this.getTableWidget().getButtonBar();
        if (editButtons != null) {
            buttonPanel.add((Component)editButtons, this.cc.xy(1, 1));
        }
        if (tableButtonBar != null) {
            buttonPanel.add((Component)tableButtonBar, this.cc.xy(3, 1));
        }
        buttonPanel.add((Component)this.getTableWidget().getListSummaryLabel(), this.cc.xy(5, 1));
        return buttonPanel;
    }

    protected JComponent getEditButtons() {
        if (!this.isAddRowSupported() && !this.isUpdateRowSupported()) {
            return null;
        }
        ColumnSpec[] columnSpecs = new ColumnSpec[]{FILL_NOGROW_COLUMN_SPEC, FormFactory.RELATED_GAP_COLSPEC, FILL_NOGROW_COLUMN_SPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FILL_NOGROW_COLUMN_SPEC};
        RowSpec[] rowSpecs = new RowSpec[]{FILL_ROW_SPEC};
        FormLayout formLayout = new FormLayout(columnSpecs, rowSpecs);
        JPanel buttonPanel = new JPanel((LayoutManager)formLayout);
        buttonPanel.add((Component)this.getCommitComponent(), this.cc.xy(1, 1));
        buttonPanel.add((Component)this.getRevertCommand().createButton(), this.cc.xy(3, 1));
        if (this.isAddRowSupported()) {
            buttonPanel.add((Component)new JSeparator(1), this.cc.xy(5, 1));
            buttonPanel.add((Component)this.createQuickAddCheckBox(), this.cc.xy(7, 1));
        }
        return buttonPanel;
    }

    protected JComponent getCommitComponent() {
        if (this.isAddRowSupported() && this.isUpdateRowSupported()) {
            this.saveUpdateSwitcher = new CardLayout();
            this.saveUpdatePanel = new JPanel(this.saveUpdateSwitcher);
            this.saveUpdatePanel.add((Component)this.getCreateCommand().createButton(), CREATE_COMMAND_ID);
            this.saveUpdatePanel.add((Component)this.getUpdateCommand().createButton(), UPDATE_COMMAND_ID);
            return this.saveUpdatePanel;
        }
        if (this.isAddRowSupported()) {
            DefaultButtonFocusListener.setDefaultButton(this.getDetailForm().getControl(), this.getCreateCommand());
            return this.getCreateCommand().createButton();
        }
        DefaultButtonFocusListener.setDefaultButton(this.getDetailForm().getControl(), this.getUpdateCommand());
        return this.getUpdateCommand().createButton();
    }

    protected ActionCommand getCommitCommand() {
        if (this.selectedRowObject == null && this.isAddRowSupported()) {
            return this.getCreateCommand();
        }
        if (this.isUpdateRowSupported()) {
            return this.getUpdateCommand();
        }
        return null;
    }

    public ActionCommand getUpdateCommand() {
        if (this.updateCommand == null) {
            this.updateCommand = this.createUpdateCommand();
        }
        return this.updateCommand;
    }

    protected ActionCommand createUpdateCommand() {
        ActionCommand command = new ActionCommand(UPDATE_COMMAND_ID){

            protected void doExecuteCommand() {
                AbstractDataEditorWidget.this.doUpdate();
            }
        };
        command.setSecurityControllerId(this.getId() + "." + UPDATE_COMMAND_ID);
        this.getCommandConfigurer().configure(command);
        this.getDetailForm().addGuarded(command, 7);
        return command;
    }

    protected void doUpdate() {
        this.getDetailForm().commit();
        Object savedObject = null;
        try {
            savedObject = this.saveEntity(this.getDetailForm().getFormObject());
            this.setDetailFormObject(savedObject, this.tableSelectionObserver, false);
        }
        catch (RuntimeException e) {
            Object changedObject = this.getDetailForm().getFormObject();
            boolean success = this.setDetailFormObject(changedObject, this.tableSelectionObserver, true);
            if (success) {
                RcpSupport.mapObjectOnFormModel(this.getDetailForm().getFormModel(), changedObject);
            }
            throw e;
        }
    }

    public ActionCommand getCreateCommand() {
        if (this.createRowCommand == null) {
            this.createRowCommand = this.createCreateCommand();
        }
        return this.createRowCommand;
    }

    protected ActionCommand createCreateCommand() {
        ActionCommand command = new ActionCommand(CREATE_COMMAND_ID){

            protected void doExecuteCommand() {
                AbstractDataEditorWidget.this.doCreate();
            }
        };
        command.setSecurityControllerId(this.getId() + "." + CREATE_COMMAND_ID);
        this.getCommandConfigurer().configure(command);
        this.getDetailForm().addGuarded(command, 7);
        return command;
    }

    protected void doCreate() {
        this.getDetailForm().commit();
        Object newObject = null;
        try {
            newObject = this.createNewEntity(this.getDetailForm().getFormObject());
            if (newObject != null && !this.getTableWidget().hasSelection() && this.getTableWidget().selectRowObject(newObject, null) == -1) {
                this.setSearchString(null);
                this.getTableWidget().selectRowObject(newObject, null);
            }
        }
        catch (RuntimeException e) {
            Object changedFormObject = this.getDetailForm().getFormObject();
            this.newRow(null);
            RcpSupport.mapObjectOnFormModel(this.getDetailForm().getFormModel(), changedFormObject);
            throw e;
        }
    }

    protected AbstractCommand getRevertCommand() {
        return this.getDetailForm().getRevertCommand();
    }

    protected abstract DefaultValidationResultsModel getValidationResults();

    @Override
    public ValidationResultsReporter newSingleLineResultsReporter(Messagable messagable) {
        return new SimpleValidationResultsReporter(this.getValidationResults(), messagable);
    }

    protected JComponent createQuickAddCheckBox() {
        this.quickAddCheckBox = new JCheckBox(RcpSupport.getMessage(this.getId(), QUICKADD, "title"));
        this.quickAddCheckBox.setFocusable(false);
        this.getCreateCommand().addCommandInterceptor(new ActionCommandInterceptor(){

            public boolean preExecution(ActionCommand command) {
                return true;
            }

            public void postExecution(ActionCommand command) {
                if (AbstractDataEditorWidget.this.quickAddCheckBox.isSelected()) {
                    AbstractDataEditorWidget.this.getAddRowCommand().execute();
                }
            }
        });
        this.quickAddCheckBox.setEnabled(this.getAddRowCommand().isEnabled());
        this.getAddRowCommand().addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = evt.getNewValue();
                AbstractDataEditorWidget.this.quickAddCheckBox.setEnabled((Boolean)newValue);
            }
        });
        return this.quickAddCheckBox;
    }

    protected JComponent getTableFilterPanel() {
        JComponent tableScroller;
        ColumnSpec[] columnSpecs = new ColumnSpec[]{FILL_COLUMN_SPEC};
        RowSpec[] rowSpecs = new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FILL_ROW_SPEC};
        JPanel top = new JPanel((LayoutManager)new FormLayout(columnSpecs, rowSpecs));
        JTable table = this.getTableWidget().getTable();
        if (this.isUpdateRowSupported()) {
            String tooltip = RcpSupport.getMessage(this.getId(), DBLCLICKSELECTS, "caption");
            table.setToolTipText(tooltip);
        }
        CommandGroup tableGroup = this.getTablePopupMenuCommandGroup();
        table.addMouseListener(new TableMouseListener(table, tableGroup.createPopupMenu()));
        JComponent tableAndOptionalFilter = tableScroller = this.getTableWidget().getComponent();
        if (this.isFilterSupported()) {
            JSplitPane splitPane = new JSplitPane();
            if (this.selectMode) {
                splitPane.setDividerLocation(-1);
                this.toggleFilterCommand = new SplitPaneExpansionToggleCommand("openfilter", splitPane, false);
            } else {
                splitPane.setDividerLocation(Integer.MAX_VALUE);
                this.toggleFilterCommand = new SplitPaneExpansionToggleCommand("openfilter", splitPane, true);
            }
            splitPane.setLastDividerLocation(Integer.MAX_VALUE);
            splitPane.setOneTouchExpandable(true);
            splitPane.setResizeWeight(1.0);
            this.toggleFilterCommand.setEnabled(this.isFilterSupported());
            splitPane.setLeftComponent(tableScroller);
            JComponent filterPanel = this.getFilterPanel();
            splitPane.setRightComponent(filterPanel);
            tableAndOptionalFilter = splitPane;
        }
        top.add((Component)this.getTableFilterControlPanel(), this.cc.xy(1, 1));
        top.add((Component)tableAndOptionalFilter, this.cc.xy(1, 3));
        return top;
    }

    protected CommandGroup getTablePopupMenuCommandGroup() {
        return CommandGroup.createCommandGroup(new Object[]{this.getEditRowCommand(), "separator", this.getAddRowCommand(), this.getCloneRowCommand(), this.getRemoveRowsCommand(), "separator", this.getRefreshCommand(), "separator", this.getCopySelectedRowsToClipboardCommand()});
    }

    private JComponent getFilterPanel() {
        if (!this.isFilterSupported()) {
            return null;
        }
        ColumnSpec[] columnSpecs = new ColumnSpec[]{FILL_COLUMN_SPEC};
        RowSpec[] rowSpecs = new RowSpec[]{new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC};
        JPanel filterPanel = new JPanel((LayoutManager)new FormLayout(columnSpecs, rowSpecs));
        JComponent filterFormControl = this.getFilterForm().getControl();
        filterFormControl.setBorder(Borders.DIALOG_BORDER);
        final JScrollPane filterScroller = new JScrollPane(filterFormControl, 20, 31);
        filterScroller.getHorizontalScrollBar().getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (filterScroller.getVerticalScrollBar().isVisible()) {
                    filterScroller.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
                } else {
                    filterScroller.setBorder(null);
                }
            }
        });
        Dimension scrollDimension = new Dimension(filterScroller.getPreferredSize().width + filterScroller.getVerticalScrollBar().getPreferredSize().width, 50);
        filterScroller.setMinimumSize(scrollDimension);
        filterPanel.add((Component)filterScroller, this.cc.xy(1, 1));
        JComponent filterControlPanel = this.getFilterControlPanel();
        filterControlPanel.setBorder(Borders.DIALOG_BORDER);
        filterPanel.add((Component)filterControlPanel, this.cc.xy(1, 3));
        DefaultButtonFocusListener.setDefaultButton(filterPanel, this.getExecuteFilterCommand());
        return filterPanel;
    }

    private JComponent getFilterControlPanel() {
        CommandGroup controlCommands = CommandGroup.createCommandGroup(new Object[]{this.getExecuteFilterCommand(), this.getEmptyFilterCommand()});
        return controlCommands.createButtonBar((Size)null, (Border)null);
    }

    private JComponent getTableFilterControlPanel() {
        CommandGroup tableFilterControlCommands = this.isFilterSupported() ? this.getTableFilterControlCommands() : null;
        ColumnSpec[] columnSpecs = this.getTableColumnSpecs(tableFilterControlCommands != null && tableFilterControlCommands.size() > 0);
        RowSpec[] rowSpecs = new RowSpec[]{FILL_ROW_SPEC};
        FormLayout formLayout = new FormLayout(columnSpecs, rowSpecs);
        JPanel buttonPanel = new JPanel((LayoutManager)formLayout);
        int columnCounter = 1;
        if (this.isAddRowSupported()) {
            buttonPanel.add((Component)this.getAddRowCommand().createButton(), this.cc.xy(columnCounter, 1));
            columnCounter += 2;
        }
        if (this.isRemoveRowsSupported()) {
            buttonPanel.add((Component)this.getRemoveRowsCommand().createButton(), this.cc.xy(columnCounter, 1));
            columnCounter += 2;
        }
        if (this.isAddRowSupported() || this.isRemoveRowsSupported()) {
            buttonPanel.add((Component)new JSeparator(1), this.cc.xy(columnCounter, 1));
            columnCounter += 2;
        }
        buttonPanel.add((Component)this.getRefreshCommand().createButton(), this.cc.xy(columnCounter, 1));
        buttonPanel.add((Component)new JSeparator(1), this.cc.xy(columnCounter += 2, 1));
        columnCounter += 2;
        this.textFilterField = this.getTableWidget().getTextFilterField();
        if (this.textFilterField != null) {
            this.textFilterField.setText(this.searchString);
            this.textFilterField.setPreferredSize(new Dimension(50, 20));
            buttonPanel.add((Component)this.textFilterField, this.cc.xy(columnCounter, 1));
            columnCounter += 2;
        }
        if (this.isFilterSupported() && tableFilterControlCommands.size() > 0) {
            buttonPanel.add((Component)new JSeparator(1), this.cc.xy(columnCounter, 1));
            buttonPanel.add((Component)tableFilterControlCommands.createButtonBar(new ColumnSpec("fill:pref:nogrow"), new RowSpec("fill:default:nogrow"), null), this.cc.xy(columnCounter += 2, 1));
        }
        return buttonPanel;
    }

    protected CommandGroup getTableFilterControlCommands() {
        CommandGroup group = new CommandGroup();
        group.add(this.getToggleFilterCommand());
        group.add(this.getClearFilterCommand());
        return group;
    }

    private ColumnSpec[] getTableColumnSpecs(boolean addFilterCommands) {
        ArrayList<ColumnSpec> columnSpecs = new ArrayList<ColumnSpec>();
        if (this.isAddRowSupported()) {
            columnSpecs.add(FILL_NOGROW_COLUMN_SPEC);
            columnSpecs.add(FormFactory.RELATED_GAP_COLSPEC);
        }
        if (this.isRemoveRowsSupported()) {
            columnSpecs.add(FILL_NOGROW_COLUMN_SPEC);
            columnSpecs.add(FormFactory.RELATED_GAP_COLSPEC);
        }
        if (this.isAddRowSupported() || this.isRemoveRowsSupported()) {
            columnSpecs.add(FormFactory.DEFAULT_COLSPEC);
            columnSpecs.add(FormFactory.RELATED_GAP_COLSPEC);
        }
        columnSpecs.add(FILL_NOGROW_COLUMN_SPEC);
        columnSpecs.add(FormFactory.RELATED_GAP_COLSPEC);
        columnSpecs.add(FormFactory.DEFAULT_COLSPEC);
        columnSpecs.add(FormFactory.RELATED_GAP_COLSPEC);
        columnSpecs.add(FILL_COLUMN_SPEC);
        if (addFilterCommands) {
            columnSpecs.add(FormFactory.RELATED_GAP_COLSPEC);
            columnSpecs.add(FormFactory.DEFAULT_COLSPEC);
            columnSpecs.add(FormFactory.RELATED_GAP_COLSPEC);
            columnSpecs.add(FILL_NOGROW_COLUMN_SPEC);
        }
        return columnSpecs.toArray(new ColumnSpec[0]);
    }

    protected void onRowSelection(Object rowObject) {
        if (rowObject instanceof Object[]) {
            this.getEditRowCommand().setEnabled(false);
            this.getCloneRowCommand().setEnabled(false);
        } else {
            this.getEditRowCommand().setEnabled(this.isUpdateRowSupported());
            this.getCloneRowCommand().setEnabled(this.isCloneRowSupported());
        }
    }

    protected void newRow(Object newClone) {
        this.getTableWidget().unSelectAll();
        this.selectedRowObject = null;
        AbstractForm detailForm = this.getDetailForm();
        if (detailForm instanceof NewFormObjectAware) {
            ((NewFormObjectAware)((Object)detailForm)).setNewFormObject(newClone);
        } else {
            detailForm.setFormObject(newClone);
        }
        if (this.saveUpdateSwitcher != null) {
            DefaultButtonFocusListener.setDefaultButton(detailForm.getControl(), this.getCreateCommand());
            this.saveUpdateSwitcher.show(this.saveUpdatePanel, CREATE_COMMAND_ID);
        }
        if (detailForm instanceof Focussable) {
            ((Focussable)((Object)detailForm)).grabFocus();
        }
    }

    protected void removeRows() {
        Object[] selectedRows = this.getTableWidget().getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        int answer = RcpSupport.showWarningDialog(this.getComponent(), REMOVE_CONFIRMATION_ID, new Object[]{selectedRows.length}, 0);
        int nextSelectionIndex = this.getTableWidget().getTable().getSelectionModel().getMinSelectionIndex();
        for (int i = 0; i < selectedRows.length && answer == 0; ++i) {
            Object objectToRemove = selectedRows[i];
            try {
                this.removeEntity(objectToRemove);
                continue;
            }
            catch (RuntimeException e) {
                log.error((Object)("Error removing row in DataEditor of type " + this.getClass().getName()), (Throwable)e);
                RcpSupport.handleException(e);
                int remaining = selectedRows.length - i - 1;
                if (remaining <= 0) continue;
                String ttl = RcpSupport.getMessage(this.getId(), REMOVE_CONTINUE_AFTER_ERROR, "title");
                String errMsg = RcpSupport.getMessage(this.getId(), REMOVE_CONTINUE_AFTER_ERROR, "text", new Object[]{remaining});
                answer = JOptionPane.showConfirmDialog(this.getComponent(), errMsg, ttl, 0, 3);
            }
        }
        int nrOfRows = this.getTableWidget().nrOfRows();
        if (nrOfRows > 0 && this.getTableWidget().getSelectedRows().length == 0) {
            if (nextSelectionIndex >= nrOfRows) {
                nextSelectionIndex = nrOfRows - 1;
            }
            this.getTableWidget().selectRowObject(nextSelectionIndex, (Observer)null);
        }
    }

    public AbstractCommand getToggleDetailCommand() {
        return this.toggleDetailCommand;
    }

    public SplitPaneExpansionToggleCommand getToggleFilterCommand() {
        return this.toggleFilterCommand;
    }

    protected ActionCommand getAddRowCommand() {
        if (this.addRowCommand == null) {
            this.addRowCommand = this.createAddRowCommand();
        }
        return this.addRowCommand;
    }

    protected ActionCommand createAddRowCommand() {
        ActionCommand addRowCommand = new ActionCommand("addrow"){

            protected void doExecuteCommand() {
                if (AbstractDataEditorWidget.this.canClose()) {
                    AbstractDataEditorWidget.this.newRow(null);
                    AbstractDataEditorWidget.this.toggleDetailCommand.doShow();
                }
            }
        };
        addRowCommand.setSecurityControllerId(this.getId() + ".addrow");
        this.commandConfigurer.configure(addRowCommand);
        addRowCommand.setEnabled(this.isAddRowSupported());
        return addRowCommand;
    }

    protected ActionCommand getEditRowCommand() {
        if (this.editRowCommand == null) {
            this.editRowCommand = this.createEditRowCommand();
        }
        return this.editRowCommand;
    }

    protected ActionCommand createEditRowCommand() {
        ActionCommand editRow = new ActionCommand("editrow"){

            protected void doExecuteCommand() {
                AbstractDataEditorWidget.this.toggleDetailCommand.doShow();
                if (AbstractDataEditorWidget.this.getDetailForm() instanceof Focussable) {
                    ((Focussable)((Object)AbstractDataEditorWidget.this.getDetailForm())).grabFocus();
                }
            }
        };
        editRow.setSecurityControllerId(this.getId() + ".editrow");
        this.commandConfigurer.configure(editRow);
        editRow.setEnabled(this.isUpdateRowSupported());
        return editRow;
    }

    protected ActionCommand getCloneRowCommand() {
        if (this.cloneRowCommand == null) {
            this.cloneRowCommand = this.createCloneRowCommand();
        }
        return this.cloneRowCommand;
    }

    protected ActionCommand createCloneRowCommand() {
        ActionCommand cloneRow = new ActionCommand("clonerow"){

            protected void doExecuteCommand() {
                Object newClone = AbstractDataEditorWidget.this.cloneEntity(AbstractDataEditorWidget.this.selectedRowObject);
                AbstractDataEditorWidget.this.newRow(newClone);
                AbstractDataEditorWidget.this.toggleDetailCommand.doShow();
            }
        };
        cloneRow.setSecurityControllerId(this.getId() + ".clonerow");
        this.commandConfigurer.configure(cloneRow);
        cloneRow.setEnabled(this.isCloneRowSupported());
        return cloneRow;
    }

    protected ActionCommand getRemoveRowsCommand() {
        if (this.removeRowsCommand == null) {
            this.removeRowsCommand = this.createRemoveRowCommand();
        }
        return this.removeRowsCommand;
    }

    protected ActionCommand createRemoveRowCommand() {
        ActionCommand removeRowCommand = new ActionCommand("removerow"){

            protected void doExecuteCommand() {
                AbstractDataEditorWidget.this.removeRows();
            }
        };
        removeRowCommand.setSecurityControllerId(this.getId() + ".removerow");
        this.commandConfigurer.configure(removeRowCommand);
        removeRowCommand.setEnabled(this.isRemoveRowsSupported());
        return removeRowCommand;
    }

    public ActionCommand getRefreshCommand() {
        if (this.refreshCommand == null) {
            this.refreshCommand = this.createRefreshCommand();
        }
        return this.refreshCommand;
    }

    public ActionCommand getCopySelectedRowsToClipboardCommand() {
        if (this.copySelectedRowsCommand == null) {
            this.copySelectedRowsCommand = this.createCopySelectedRowsToClipboardCommand();
        }
        return this.copySelectedRowsCommand;
    }

    private ActionCommand createCopySelectedRowsToClipboardCommand() {
        ActionCommand command = new ActionCommand("copyToClipboard"){

            protected void doExecuteCommand() {
                String clipboardContent = this.createTabDelimitedSelectedRowsContent();
                StringSelection selection = new StringSelection(clipboardContent);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, null);
            }

            /*
             * WARNING - void declaration
             */
            private String createTabDelimitedSelectedRowsContent() {
                void var6_10;
                ArrayList formattedRowList = new ArrayList();
                JXTable jxTable = (JXTable)AbstractDataEditorWidget.this.getTableWidget().getTable();
                ArrayList<String> headerList = new ArrayList<String>();
                for (TableColumn tableColumn : jxTable.getColumns()) {
                    Object object = tableColumn.getHeaderValue();
                    headerList.add(object == null ? "" : object.toString());
                }
                formattedRowList.add(headerList);
                int[] arr$ = jxTable.getSelectedRows();
                int len$ = arr$.length;
                boolean bl = false;
                while (var6_10 < len$) {
                    int rowIndex = arr$[var6_10];
                    ArrayList<String> columnList = new ArrayList<String>();
                    for (TableColumn tableColumn : jxTable.getColumns()) {
                        Object unformattedValue = jxTable.getModel().getValueAt(rowIndex, tableColumn.getModelIndex());
                        int columnViewIndex = jxTable.convertColumnIndexToView(tableColumn.getModelIndex());
                        TableCellRenderer renderer = jxTable.getCellRenderer(rowIndex, columnViewIndex);
                        Component component = renderer.getTableCellRendererComponent((JTable)jxTable, unformattedValue, false, false, rowIndex, columnViewIndex);
                        columnList.add(this.getFormattedValue(component));
                    }
                    formattedRowList.add(columnList);
                    ++var6_10;
                }
                StringBuilder builder = new StringBuilder(formattedRowList.size() * 200);
                for (List list : formattedRowList) {
                    builder.append(StringUtils.join(list.iterator(), (String)"\t") + "\n");
                }
                return builder.toString();
            }

            private String getFormattedValue(Component component) {
                if (component instanceof JLabel) {
                    return ((JLabel)component).getText();
                }
                if (component instanceof JTextComponent) {
                    return ((JTextComponent)component).getText();
                }
                if (component instanceof JToggleButton) {
                    JToggleButton button = (JToggleButton)component;
                    return RcpSupport.getMessage("boolean.yesno." + button.isSelected());
                }
                return component.toString();
            }
        };
        return command;
    }

    protected ActionCommand createRefreshCommand() {
        return this.makeExecuteFilterCommand("refresh", false);
    }

    public ActionCommand getClearFilterCommand() {
        if (this.clearFilterCommand == null) {
            this.clearFilterCommand = this.createClearFilterCommand();
        }
        return this.clearFilterCommand;
    }

    protected ActionCommand createClearFilterCommand() {
        ActionCommand newCommand = this.makeClearFilterCommand("clearfilter", true);
        newCommand.setEnabled(this.isFilterSupported());
        return newCommand;
    }

    private ActionCommand makeClearFilterCommand(String id, final boolean refreshAndHideAfterClear) {
        ActionCommand newCommand = new ActionCommand(id){

            protected void doExecuteCommand() {
                AbstractDataEditorWidget.this.getFilterForm().resetCriteria();
                if (refreshAndHideAfterClear) {
                    AbstractDataEditorWidget.this.executeFilter();
                    AbstractDataEditorWidget.this.toggleFilterCommand.doHide();
                }
            }
        };
        this.commandConfigurer.configure(newCommand);
        return newCommand;
    }

    public ActionCommand getExecuteFilterCommand() {
        if (this.executeFilterCommand == null) {
            this.executeFilterCommand = this.createExecuteFilterCommand();
        }
        return this.executeFilterCommand;
    }

    protected ActionCommand createExecuteFilterCommand() {
        ActionCommand newCommand = this.makeExecuteFilterCommand("executefilter", true);
        newCommand.setEnabled(this.isFilterSupported());
        return newCommand;
    }

    private ActionCommand makeExecuteFilterCommand(String id, final boolean commitFilter) {
        ActionCommand newCommand = new ActionCommand(id){

            protected void doExecuteCommand() {
                if (AbstractDataEditorWidget.this.textFilterField != null) {
                    AbstractDataEditorWidget.this.textFilterField.setText("");
                }
                if (commitFilter && AbstractDataEditorWidget.this.isFilterSupported()) {
                    AbstractDataEditorWidget.this.getFilterForm().commit();
                }
                AbstractDataEditorWidget.this.executeFilter();
            }
        };
        if (this.isFilterSupported()) {
            new FormGuard(this.getFilterForm().getFormModel(), newCommand, 1);
        }
        this.commandConfigurer.configure(newCommand);
        return newCommand;
    }

    protected ActionCommand getEmptyFilterCommand() {
        if (this.emptyFilterCommand == null) {
            this.emptyFilterCommand = this.createEmptyFilterCommand();
        }
        return this.emptyFilterCommand;
    }

    protected ActionCommand createEmptyFilterCommand() {
        ActionCommand newCommand = this.makeClearFilterCommand("emptyfilter", false);
        newCommand.setEnabled(this.isFilterSupported());
        return newCommand;
    }

    protected AbstractCommand getHelpCommand() {
        return RcpSupport.createDummyCommand("help", "Behulpzaam");
    }

    private AbstractCommand getCloseCommand() {
        return RcpSupport.createDummyCommand("exit", "deuren toe.");
    }

    protected Object[] getFilterCriteria() {
        Object[] criteria = new Object[]{this.getFilterForm().getFilterCriteria()};
        return criteria;
    }

    protected ActionCommand getSelectCommand() {
        return RcpSupport.createDummyCommand("select", "Chosen!");
    }

    protected AbstractCommand[] getControlCommands() {
        if (this.isSelectMode()) {
            return new AbstractCommand[]{this.getSelectCommand(), this.getCloseCommand()};
        }
        return new AbstractCommand[]{this.getCloseCommand()};
    }

    protected abstract boolean isFilterSupported();

    protected abstract boolean isUpdateRowSupported();

    protected abstract boolean isAddRowSupported();

    protected abstract boolean isCloneRowSupported();

    protected abstract boolean isRemoveRowsSupported();

    protected abstract FilterForm getFilterForm();

    public abstract AbstractForm getDetailForm();

    public abstract Widget createDetailWidget();

    public abstract TableWidget getTableWidget();

    protected abstract void executeFilter();

    public abstract void executeFilter(Map<String, Object> var1);

    protected final Object loadEntityDetails(Object baseObject) {
        return this.loadEntityDetails(baseObject, false);
    }

    protected abstract Object loadEntityDetails(Object var1, boolean var2);

    protected abstract Object saveEntity(Object var1);

    protected abstract Object createNewEntity(Object var1);

    protected abstract Object cloneEntity(Object var1);

    protected abstract void removeEntity(Object var1);

    @Override
    public boolean canClose() {
        boolean userBreak = false;
        int answer = 1;
        ValidatingFormModel detailFormModel = this.getDetailForm().getFormModel();
        if (detailFormModel.isEnabled() && detailFormModel.isDirty()) {
            answer = detailFormModel.isCommittable() ? RcpSupport.showWarningDialog((Component)this.getComponent(), UNSAVEDCHANGES_WARNING_ID, 1) : ((answer = RcpSupport.showWarningDialog((Component)this.getComponent(), UNSAVEDCHANGES_UNCOMMITTABLE_WARNING_ID, 0)) == 0 ? 2 : 1);
            switch (answer) {
                case 2: {
                    userBreak = true;
                    break;
                }
                case 0: {
                    this.getCommitCommand().execute();
                    break;
                }
                case 1: {
                    detailFormModel.revert();
                }
            }
        }
        return !userBreak;
    }

    private boolean setDetailFormObject(Object rowObject, Observer reportingObserver, boolean forceLoad) {
        if (!forceLoad && rowObject == this.selectedRowObject) {
            return true;
        }
        if (this.saveUpdateSwitcher != null) {
            DefaultButtonFocusListener.setDefaultButton(this.getDetailForm().getControl(), this.getUpdateCommand());
            this.saveUpdateSwitcher.show(this.saveUpdatePanel, UPDATE_COMMAND_ID);
        }
        if (!this.canClose()) {
            this.getTableWidget().selectRowObject(this.selectedRowObject, reportingObserver);
            return false;
        }
        boolean success = true;
        if (rowObject != null) {
            Object detailedObject = this.loadEntityDetails(rowObject, forceLoad);
            if (detailedObject == null) {
                this.getTableWidget().removeRowObject(rowObject);
                rowObject = null;
                success = false;
            } else if (detailedObject != rowObject) {
                this.replaceRowObject(rowObject, detailedObject);
                rowObject = detailedObject;
            }
        }
        this.getDetailForm().setFormObject(rowObject);
        this.selectedRowObject = rowObject;
        this.onRowSelection(rowObject);
        return success;
    }

    protected void replaceRowObject(Object oldRowObject, Object newRowObject) {
        EventQueue.invokeLater(new RowObjectReplacer(oldRowObject, newRowObject));
    }

    public final void setDataProviderEventSources(List dataProviderEventSources) {
        if (this.dataProviderSources == null) {
            this.dataProviderSources = new HashMap();
        }
        for (DataProviderEventSource source : dataProviderEventSources) {
            this.dataProviderSources.put(source.getClass(), source);
        }
    }

    public final void addDataProviderListener(Class dataProviderEventSource, DataProviderListener listener) {
        Object source = this.dataProviderSources.get(dataProviderEventSource);
        if (source != null) {
            ((DataProviderEventSource)source).addDataProviderListener(listener);
        }
    }

    public final void removeDataProviderListener(Class dataProviderEventSource, DataProviderListener listener) {
        Object source = this.dataProviderSources.get(dataProviderEventSource);
        if (source != null) {
            ((DataProviderEventSource)source).removeDataProviderListener(listener);
        }
    }

    @Override
    public Object getSelection() {
        return this.getTableWidget().getSelectedRows();
    }

    @Override
    public void setSelectionCommand(ActionCommand command) {
        this.setSelectMode(true);
        this.selectionCommand = command;
        this.enableSelectButton(this.getSelection());
    }

    public void setMultipleSelectionInSelectMode(boolean multipleSelection) {
        this.multipleSelectionInSelectMode = multipleSelection;
    }

    @Override
    public void removeSelectionCommand() {
        this.selectionCommand = null;
        this.setSelectMode(false);
    }

    private void enableSelectButton(Object selection) {
        if (this.selectionCommand != null) {
            if (selection == null) {
                this.selectionCommand.setEnabled(false);
            } else if (this.multipleSelectionInSelectMode) {
                this.selectionCommand.setEnabled(true);
            } else {
                this.selectionCommand.setEnabled(!(selection instanceof Object[]) || ((Object[])selection).length == 1);
            }
        }
    }

    private class ListSelectionObserver
    implements Observer {
        private ListSelectionObserver() {
        }

        public void update(Observable o, Object rowObject) {
            AbstractDataEditorWidget.this.setDetailFormObject(rowObject instanceof Object[] ? null : rowObject, AbstractDataEditorWidget.this.tableSelectionObserver, false);
            AbstractDataEditorWidget.this.enableSelectButton(rowObject);
        }
    }

    class RowObjectReplacer
    implements Runnable {
        private final Object oldObject;
        private final Object newObject;

        public RowObjectReplacer(Object oldObject, Object newObject) {
            this.oldObject = oldObject;
            this.newObject = newObject;
        }

        public void run() {
            AbstractDataEditorWidget.this.getTableWidget().replaceRowObject(this.oldObject, this.newObject, AbstractDataEditorWidget.this.tableSelectionObserver);
        }
    }

    private final class TableMouseListener
    extends MouseAdapter {
        private final JTable table;
        private final JPopupMenu menu;

        private TableMouseListener(JTable table, JPopupMenu menu) {
            this.table = table;
            this.menu = menu;
        }

        private void handlePopupTrigger(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Point p = e.getPoint();
                int row = this.table.rowAtPoint(p);
                int column = this.table.columnAtPoint(p);
                if (!this.table.isRowSelected(row) && column != -1) {
                    this.table.changeSelection(row, column, e.isControlDown(), e.isShiftDown());
                }
                this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            this.handlePopupTrigger(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.handlePopupTrigger(e);
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                if (AbstractDataEditorWidget.this.selectionCommand != null) {
                    AbstractDataEditorWidget.this.selectionCommand.execute();
                } else if (AbstractDataEditorWidget.this.isUpdateRowSupported()) {
                    AbstractDataEditorWidget.this.getEditRowCommand().execute();
                }
            }
        }
    }
}

