/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget.editor.provider;

import java.util.Observable;
import org.springframework.richclient.widget.editor.provider.DataProvider;
import org.springframework.richclient.widget.editor.provider.DataProviderEvent;
import org.springframework.richclient.widget.editor.provider.DataProviderListener;

public abstract class AbstractDataProvider
extends Observable
implements DataProvider {
    private final String id;

    public AbstractDataProvider() {
        this("abstractDataProvider");
    }

    public AbstractDataProvider(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public final Object getDetailObject(Object selectedObject, boolean forceLoad) {
        if (forceLoad || !this.isDetailObject(selectedObject)) {
            return this.loadDetailObject(selectedObject);
        }
        return selectedObject;
    }

    protected boolean isDetailObject(Object objectToCheck) {
        return true;
    }

    protected Object loadDetailObject(Object baseObject) {
        throw new UnsupportedOperationException("getDetailObject(object) not implemented for " + baseObject);
    }

    public Object clone(Object sampleData) {
        throw new UnsupportedOperationException("clone(object) not implemented for " + sampleData);
    }

    public final Object update(Object updatedData) {
        this.setChanged();
        Object newEntity = this.doUpdate(updatedData);
        this.notifyObservers(DataProviderEvent.updateEntityEvent(updatedData, newEntity));
        return newEntity;
    }

    public Object doUpdate(Object updatedData) {
        throw new UnsupportedOperationException("doUpdate(object) not implemented for " + updatedData);
    }

    public final void delete(Object dataToRemove) {
        this.setChanged();
        this.doDelete(dataToRemove);
        this.notifyObservers(DataProviderEvent.deleteEntityEvent(dataToRemove));
    }

    public void doDelete(Object dataToRemove) {
        throw new UnsupportedOperationException("doDelete(object) not implemented for " + dataToRemove);
    }

    public final Object create(Object newData) {
        this.setChanged();
        Object newEntity = this.doCreate(newData);
        this.notifyObservers(DataProviderEvent.newEntityEvent(newEntity));
        return newEntity;
    }

    public Object doCreate(Object newData) {
        throw new UnsupportedOperationException("doCreate(object) not implemented for " + newData);
    }

    public Object newInstance(Object criteria) {
        return null;
    }

    public void addDataProviderListener(DataProviderListener dataProviderListener) {
        this.addObserver(dataProviderListener);
    }

    public void removeDataProviderListener(DataProviderListener dataProviderListener) {
        this.deleteObserver(dataProviderListener);
    }

    public boolean supportsBaseCriteria() {
        return false;
    }

    public void setBaseCriteria(Object criteria) {
        throw new UnsupportedOperationException("setBaseCriteria(object) not implemented for " + criteria);
    }

    public boolean exists(Object data) {
        return false;
    }

    public DataProvider.RefreshPolicy getRefreshPolicy() {
        return DataProvider.RefreshPolicy.ON_USER_SWITCH;
    }

    public Object getSimpleObject(Object baseObject) {
        return baseObject;
    }
}

