/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget.table;

import java.lang.reflect.Method;
import org.apache.commons.beanutils.MethodUtils;
import org.springframework.richclient.widget.table.Accessor;
import org.springframework.richclient.widget.table.NestedAccessor;
import org.springframework.richclient.widget.table.NestedWriter;
import org.springframework.richclient.widget.table.SimpleAccessor;
import org.springframework.richclient.widget.table.SimpleWriter;
import org.springframework.richclient.widget.table.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtils {
    private ClassUtils() {
    }

    public static Method getReadMethod(Class<?> clazz, String propertyName) throws NoSuchMethodError {
        String propertyNameCapitalized = ClassUtils.capitalize(propertyName);
        try {
            return clazz.getMethod("get" + propertyNameCapitalized, new Class[0]);
        }
        catch (Exception e) {
            try {
                return clazz.getMethod("is" + propertyNameCapitalized, new Class[0]);
            }
            catch (Exception e1) {
                throw new NoSuchMethodError("Could not find getter (getXX or isXXX) for property: " + propertyName);
            }
        }
    }

    public static Class<?> getTypeForProperty(Method getter) {
        Class<?> returnType = getter.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            throw new IllegalArgumentException("Getter " + getter.toString() + " does not have a returntype.");
        }
        if (returnType.isPrimitive()) {
            return MethodUtils.getPrimitiveWrapper(returnType);
        }
        return returnType;
    }

    public static final Method getWriteMethod(Class<?> clazz, String propertyName, Class<?> propertyType) {
        String propertyNameCapitalized = ClassUtils.capitalize(propertyName);
        try {
            return clazz.getMethod("set" + propertyNameCapitalized, propertyType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static Accessor getAccessorForProperty(Class<?> clazz, String propertyName) {
        int splitPoint = propertyName.indexOf(46);
        if (splitPoint > 0) {
            String firstPart = propertyName.substring(0, splitPoint);
            String secondPart = propertyName.substring(splitPoint + 1);
            return new NestedAccessor(clazz, firstPart, secondPart);
        }
        return new SimpleAccessor(clazz, propertyName);
    }

    public static Writer getWriterForProperty(Class<?> beanClass, String propertyName) {
        int splitPoint = propertyName.indexOf(46);
        if (splitPoint > 0) {
            String firstPart = propertyName.substring(0, splitPoint);
            String secondPart = propertyName.substring(splitPoint + 1);
            return new NestedWriter(beanClass, firstPart, secondPart);
        }
        return new SimpleWriter(beanClass, propertyName);
    }
}

