/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget.table;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.richclient.widget.table.ClassUtils;
import org.springframework.richclient.widget.table.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedWriter
implements Writer {
    private final Writer nestedWriter;
    private final Method getter;

    public NestedWriter(Class<?> clazz, String propertyName, String nestedPropertyName) {
        this(ClassUtils.getReadMethod(clazz, propertyName), nestedPropertyName);
    }

    public NestedWriter(Method getter, String nestedPropertyName) {
        this.getter = getter;
        this.nestedWriter = ClassUtils.getWriterForProperty(getter.getReturnType(), nestedPropertyName);
    }

    @Override
    public void setValue(Object toEntity, Object newValue) throws IllegalAccessException, InvocationTargetException {
        Object propertyValue = this.getter.invoke(toEntity, new Object[0]);
        if (propertyValue != null) {
            this.nestedWriter.setValue(propertyValue, newValue);
        }
    }

    @Override
    public Class<?> getPropertyType() {
        return this.nestedWriter.getPropertyType();
    }

    @Override
    public Object getValue(Object fromEntity) throws IllegalAccessException, InvocationTargetException {
        Object propertyValue = this.getter.invoke(fromEntity, new Object[0]);
        return propertyValue == null ? null : this.nestedWriter.getValue(propertyValue);
    }
}

