/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget.table;

import java.util.Comparator;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.ValidatingFormModel;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.richclient.form.binding.BindingFactory;
import org.springframework.richclient.form.binding.swing.SwingBindingFactory;
import org.springframework.richclient.util.RcpSupport;
import org.springframework.richclient.widget.editor.AbstractDataEditorWidget;
import org.springframework.richclient.widget.table.Accessor;
import org.springframework.richclient.widget.table.ValueModelTableCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyColumn {
    public static final int UNSPECIFIED_WIDTH = -1;
    private Class<?> type;
    private Accessor accessor;
    private String propertyName;
    private String[] headerKeys;
    private int maxWidth = -1;
    private int minWidth = -1;
    private boolean resizable = true;
    private TableCellRenderer renderer;
    private TableCellEditor editor;
    private Comparator<?> comparator;
    private boolean isSelectColumn = false;
    private boolean isFilterColumn = false;
    private boolean visible = true;
    private String header = null;

    public PropertyColumn(String propertyName) {
        this.propertyName = propertyName;
    }

    public PropertyColumn(String propertyName, Accessor accessor, Class<?> propertyType) {
        this.propertyName = propertyName;
        this.accessor = accessor;
        this.type = propertyType;
    }

    public PropertyColumn(Class<?> type, Accessor accessor, String propertyName, String[] headerKeys, int minWidth, int maxWidth, boolean resizable, TableCellRenderer renderer, TableCellEditor editor, Comparator<?> comparator, boolean isSelectColumn, boolean visible) {
        this.type = type;
        this.accessor = accessor;
        this.propertyName = propertyName;
        this.headerKeys = headerKeys;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.resizable = resizable;
        this.editor = editor;
        this.renderer = renderer;
        this.comparator = comparator;
        this.isSelectColumn = isSelectColumn;
        this.visible = visible;
    }

    public void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getHeader() {
        if (this.header == null) {
            if (this.headerKeys == null) {
                this.headerKeys = new String[2];
                this.headerKeys[0] = this.getPropertyName() + ".header";
                this.headerKeys[1] = this.getPropertyName();
            }
            this.header = RcpSupport.getMessage((MessageSourceResolvable)new DefaultMessageSourceResolvable(this.headerKeys, null, this.headerKeys[this.headerKeys.length - 1]));
        }
        return "".equals(this.header) ? " " : this.header;
    }

    public String[] getHeaderKeys() {
        return this.headerKeys == null ? null : (String[])this.headerKeys.clone();
    }

    public PropertyColumn withHeaderKeys(String[] headerKeys) {
        this.setHeaderKeys(headerKeys);
        return this;
    }

    public void setHeaderKeys(String[] headerKeys) {
        this.headerKeys = headerKeys;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public PropertyColumn withMaxWidth(int maxWidth) {
        this.setMaxWidth(maxWidth);
        return this;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public PropertyColumn withMinWidth(int minWidth) {
        this.setMinWidth(minWidth);
        return this;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public PropertyColumn withFixedWidth(int width) {
        this.setMinWidth(width);
        this.setMaxWidth(width);
        return this;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public PropertyColumn withResizable(boolean resizable) {
        this.setResizable(resizable);
        return this;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public PropertyColumn withFilterColumn(boolean isFilterColumn) {
        this.setFilterColumn(isFilterColumn);
        return this;
    }

    public void setFilterColumn(boolean isFilterColumn) {
        this.isFilterColumn = isFilterColumn;
    }

    public boolean isFilterColumn() {
        return this.isFilterColumn;
    }

    public TableCellRenderer getRenderer() {
        return this.renderer;
    }

    public PropertyColumn withRenderer(TableCellRenderer renderer) {
        this.setRenderer(renderer);
        return this;
    }

    public void setRenderer(TableCellRenderer renderer) {
        this.renderer = renderer;
    }

    public TableCellEditor getEditor() {
        return this.editor;
    }

    public PropertyColumn withEditor(TableCellEditor editor) {
        this.setEditor(editor);
        return this;
    }

    public PropertyColumn withEditor(BindingFactory bindingFactory) {
        return this.withEditor(new ValueModelTableCellEditor(bindingFactory.getFormModel(), this.getPropertyName(), bindingFactory.createBinding(this.getType(), this.getPropertyName()).getControl()));
    }

    public PropertyColumn withEditor(FormModel formModel) {
        return this.withEditor(new SwingBindingFactory(formModel));
    }

    public PropertyColumn withEditor(AbstractDataEditorWidget dataEditor) {
        ValidatingFormModel formModel = dataEditor.getDetailForm().getFormModel();
        BindingFactory bindingFactory = dataEditor.getDetailForm().getBindingFactory();
        return this.withEditor(new ValueModelTableCellEditor((FormModel)formModel, this.getPropertyName(), bindingFactory.createBinding(this.getType(), this.getPropertyName()).getControl(), dataEditor.getUpdateCommand()));
    }

    public void setEditor(TableCellEditor editor) {
        this.editor = editor;
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }

    public PropertyColumn withComparator(Comparator<?> comparator) {
        this.setComparator(comparator);
        return this;
    }

    public void setComparator(Comparator<?> comparator) {
        this.comparator = comparator;
    }

    public PropertyColumn withSelectColumn(boolean isSelectColumn) {
        this.setSelectColumn(isSelectColumn);
        return this;
    }

    public boolean isSelectColumn() {
        return this.isSelectColumn;
    }

    public void setSelectColumn(boolean isSelectColumn) {
        this.isSelectColumn = isSelectColumn;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public PropertyColumn withVisible(boolean visible) {
        this.setVisible(visible);
        return this;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setHeader(String header) {
        this.header = header;
    }
}

