/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget.table;

import ca.odell.glazedlists.impl.sort.ComparableComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.util.RcpSupport;
import org.springframework.richclient.widget.table.Accessor;
import org.springframework.richclient.widget.table.ClassUtils;
import org.springframework.richclient.widget.table.PropertyColumn;
import org.springframework.richclient.widget.table.TableDescription;
import org.springframework.richclient.widget.table.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyColumnTableDescription
implements TableDescription {
    static Log log = LogFactory.getLog(PropertyColumnTableDescription.class);
    private static final int DEFAULT_SIZE = 10;
    private List<PropertyColumn> columns;
    private final String id;
    private final Class entityClass;
    private Comparator defaultComparator;
    private boolean hasSelectColumn = false;

    public PropertyColumnTableDescription(Class forEntityType) {
        this(null, forEntityType);
    }

    public PropertyColumnTableDescription(Class forEntityType, Comparator defaultComparator) {
        this(null, forEntityType, defaultComparator);
    }

    public PropertyColumnTableDescription(String id, Class forEntityType, Comparator defaultComparator) {
        this(id, forEntityType, 10, defaultComparator);
    }

    public PropertyColumnTableDescription(String id, Class forEntityType) {
        this(id, forEntityType, (Comparator)new ComparableComparator());
    }

    public PropertyColumnTableDescription(String id, Class forEntityType, int numberOfColumns) {
        this(id, forEntityType, numberOfColumns, (Comparator)new ComparableComparator());
    }

    public PropertyColumnTableDescription(String id, Class forEntityType, int numberOfColumns, Comparator defaultComparator) {
        this.id = id;
        this.entityClass = forEntityType;
        this.defaultComparator = defaultComparator;
        this.columns = new ArrayList<PropertyColumn>(numberOfColumns);
    }

    public PropertyColumn addPropertyColumn(String propertyName) {
        return this.addPropertyColumn(propertyName, (Class)null);
    }

    public PropertyColumn addPropertyColumn(String propertyName, Class<?> propertyType) {
        PropertyColumn propertyColumn;
        String[] headerKeys = RcpSupport.getMessageKeys(this.id, propertyName, "header");
        Accessor accessor = ClassUtils.getAccessorForProperty(this.entityClass, propertyName);
        if (propertyType == null) {
            propertyType = accessor.getPropertyType();
        }
        if (String.class.isAssignableFrom((propertyColumn = new PropertyColumn(propertyName, accessor, propertyType)).getType())) {
            propertyColumn.setFilterColumn(true);
        }
        propertyColumn.setHeaderKeys(headerKeys);
        this.columns.add(propertyColumn);
        return propertyColumn;
    }

    public void setPropertyColumns(Collection<PropertyColumn> propertyColumns) {
        this.columns = new ArrayList<PropertyColumn>(propertyColumns);
        for (PropertyColumn propertyColumn : this.columns) {
            Accessor accessorForProperty = ClassUtils.getAccessorForProperty(this.entityClass, propertyColumn.getPropertyName());
            propertyColumn.setAccessor(accessorForProperty);
            if (propertyColumn.getComparator() == null) {
                propertyColumn.setComparator(this.getDefaultComparator());
            }
            propertyColumn.setHeaderKeys(RcpSupport.getMessageKeys(this.id, propertyColumn.getPropertyName(), "header"));
        }
    }

    public PropertyColumn addPropertyColumn(String propertyName, int width, Comparator comparator) {
        return this.addPropertyColumn(propertyName).withFixedWidth(width).withComparator(comparator);
    }

    public PropertyColumn addPropertyColumn(String propertyName, TableCellRenderer renderer) {
        return this.addPropertyColumn(propertyName).withRenderer(renderer);
    }

    public void addPropertyColumn(String propertyName, Class propertyType, TableCellEditor editor) {
        this.addPropertyColumn(propertyName).withEditor(editor);
    }

    public void addPropertyColumn(String propertyName, Class propertyType, TableCellRenderer renderer) {
        this.addPropertyColumn(propertyName).withRenderer(renderer);
    }

    public void addPropertyColumn(String propertyName, Class propertyType, int minWidth, int maxWidth) {
        this.addPropertyColumn(propertyName).withMinWidth(minWidth).withMaxWidth(maxWidth);
    }

    public void addPropertyColumn(String propertyName, int width) {
        this.addPropertyColumn(propertyName).withFixedWidth(width);
    }

    public void addPropertyColumn(String propertyName, int width, boolean visible) {
        this.addPropertyColumn(propertyName).withFixedWidth(width).withVisible(visible);
    }

    public void addPropertyColumn(String propertyName, int width, TableCellRenderer renderer, boolean visible) {
        this.addPropertyColumn(propertyName).withFixedWidth(width).withRenderer(renderer).withVisible(visible);
    }

    public void addPropertyColumn(String propertyName, Class propertyType, int width, TableCellRenderer renderer, boolean visible) {
        this.addPropertyColumn(propertyName).withFixedWidth(width).withRenderer(renderer).withVisible(visible);
    }

    public void addPropertyColumn(String propertyName, int width, TableCellRenderer renderer) {
        this.addPropertyColumn(propertyName).withFixedWidth(width).withRenderer(renderer);
    }

    public void addPropertyColumn(String propertyName, int minWidth, int maxWidth) {
        this.addPropertyColumn(propertyName).withMinWidth(minWidth).withMaxWidth(maxWidth);
    }

    public void addPropertyColumn(String propertyName, int minWidth, int maxWidth, boolean resizable, TableCellRenderer renderer) {
        this.addPropertyColumn(propertyName).withMinWidth(minWidth).withMaxWidth(maxWidth).withResizable(resizable).withRenderer(renderer);
    }

    public void addPropertyColumn(String propertyName, int minWidth, int maxWidth, boolean resizable, TableCellRenderer renderer, Comparator comparator) {
        this.addPropertyColumn(propertyName).withMinWidth(minWidth).withMaxWidth(maxWidth).withResizable(resizable).withRenderer(renderer).withComparator(comparator);
    }

    public void addPropertyColumn(String propertyName, Class propertyType, int minWidth, int maxWidth, boolean resizable, TableCellRenderer renderer) {
        this.addPropertyColumn(propertyName).withMinWidth(minWidth).withMaxWidth(maxWidth).withResizable(resizable).withRenderer(renderer);
    }

    public void addPropertyColumn(String propertyName, Class propertyType, int minWidth, int maxWidth, boolean resizable, TableCellRenderer renderer, Comparator comparator) {
        this.addPropertyColumn(propertyName).withMinWidth(minWidth).withMaxWidth(maxWidth).withResizable(resizable).withRenderer(renderer).withComparator(comparator);
    }

    public void addPropertyColumn(String propertyName, Class propertyType, String[] headerKeys, int minWidth, int maxWidth, boolean resizable, Boolean isInTextFilter) {
        this.addPropertyColumn(propertyName).withHeaderKeys(headerKeys).withMinWidth(minWidth).withMaxWidth(maxWidth).withResizable(resizable).withFilterColumn(isInTextFilter);
    }

    public void addPropertyColumn(String propertyName, Class propertyType, String[] headerKeys, int minWidth, int maxWidth, boolean resizable, TableCellRenderer renderer, Boolean isInTextFilter) {
        this.addPropertyColumn(propertyName).withHeaderKeys(headerKeys).withMinWidth(minWidth).withMaxWidth(maxWidth).withResizable(resizable).withRenderer(renderer).withFilterColumn(isInTextFilter);
    }

    public void addPropertyColumn(String propertyName, Class propertyType, String[] headerKeys, int minWidth, int maxWidth, boolean resizable, TableCellRenderer renderer, Boolean isInTextFilter, Comparator comparator) {
        this.addPropertyColumn(propertyName).withHeaderKeys(headerKeys).withMinWidth(minWidth).withMaxWidth(maxWidth).withResizable(resizable).withRenderer(renderer).withComparator(comparator).withFilterColumn(isInTextFilter);
    }

    public void addSelectPropertyColumn(String propertyName) {
        this.addSelectPropertyColumn(propertyName, -1);
    }

    public void addSelectPropertyColumn(String propertyName, Comparator<?> comparator) {
        this.addSelectPropertyColumn(propertyName, -1, -1, comparator);
    }

    public void addSelectPropertyColumn(String propertyName, int width) {
        this.addSelectPropertyColumn(propertyName, width, width);
    }

    public void addSelectPropertyColumn(String propertyName, int minWidth, int maxWidth) {
        this.addSelectPropertyColumn(propertyName, minWidth, maxWidth, null);
    }

    public void addSelectPropertyColumn(String propertyName, int minWidth, int maxWidth, Comparator comparator) {
        this.addSelectPropertyColumn(propertyName, RcpSupport.getMessageKeys(this.id, propertyName, "header"), minWidth, maxWidth, true, comparator);
    }

    public void addSelectPropertyColumn(String propertyName, String[] headerKeys, int minWidth, int maxWidth, boolean resizable, Comparator comparator) {
        if (this.hasSelectColumn) {
            throw new IllegalArgumentException("Already a selectColumn specified, cannot set " + propertyName + " as selectColumn");
        }
        this.hasSelectColumn = true;
        Writer propertyAccessor = ClassUtils.getWriterForProperty(this.entityClass, propertyName);
        JCheckBox cellEditorComponent = new JCheckBox();
        cellEditorComponent.setHorizontalAlignment(0);
        this.columns.add(0, new PropertyColumn(Boolean.class, propertyAccessor, propertyName, headerKeys, minWidth, maxWidth, resizable, null, new DefaultCellEditor(cellEditorComponent), comparator, true, true));
    }

    public void addSelectPropertyColumn(String propertyName, String[] headerKeys, int minWidth, int maxWidth, boolean resizable, Comparator comparator, boolean visible) {
        if (this.hasSelectColumn) {
            throw new IllegalArgumentException("Already a selectColumn specified, cannot set " + propertyName + " as selectColumn");
        }
        this.hasSelectColumn = true;
        Writer propertyAccessor = ClassUtils.getWriterForProperty(this.entityClass, propertyName);
        JCheckBox cellEditorComponent = new JCheckBox();
        cellEditorComponent.setHorizontalAlignment(0);
        this.columns.add(0, new PropertyColumn(Boolean.class, propertyAccessor, propertyName, headerKeys, minWidth, maxWidth, resizable, null, new DefaultCellEditor(cellEditorComponent), comparator, true, visible));
    }

    @Override
    public Class<?> getDataType() {
        return this.entityClass;
    }

    @Override
    public Comparator<?> getDefaultComparator() {
        return this.defaultComparator;
    }

    public void setDefaultComparator(Comparator<?> defaultComparator) {
        this.defaultComparator = defaultComparator;
    }

    @Override
    public boolean hasSelectColumn() {
        return this.hasSelectColumn;
    }

    @Override
    public String[] getPropertiesInTextFilter() {
        ArrayList<String> filterProperties = new ArrayList<String>(this.getColumnCount());
        for (PropertyColumn column : this.columns) {
            if (!column.isFilterColumn()) continue;
            filterProperties.add(column.getPropertyName());
        }
        return filterProperties.toArray(new String[filterProperties.size()]);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    private PropertyColumn getPropertyColumn(int propertyIndex) {
        return this.columns.get(propertyIndex);
    }

    @Override
    public Object getValue(Object rowObject, int propertyIndex) {
        try {
            return this.getPropertyColumn(propertyIndex).getAccessor().getValue(rowObject);
        }
        catch (Exception e) {
            log.warn((Object)("Error reading property " + propertyIndex + " from object " + rowObject), (Throwable)e);
            throw new RuntimeException("Error reading property " + propertyIndex + " from object " + rowObject, e);
        }
    }

    @Override
    public void setValue(Object rowObject, int propertyIndex, Object newValue) {
        try {
            Accessor accessor = this.getPropertyColumn(propertyIndex).getAccessor();
            if (accessor instanceof Writer) {
                ((Writer)accessor).setValue(rowObject, newValue);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error writing property " + propertyIndex + " to object " + rowObject + " new value: " + newValue), (Throwable)e);
            throw new RuntimeException("Error writing property " + propertyIndex + " to object " + rowObject + " new value: " + newValue, e);
        }
    }

    @Override
    public String getHeader(int propertyIndex) {
        return this.getPropertyColumn(propertyIndex).getHeader();
    }

    @Override
    public Class getType(int propertyIndex) {
        return this.getPropertyColumn(propertyIndex).getType();
    }

    @Override
    public int getMinColumnWidth(int propertyIndex) {
        return this.getPropertyColumn(propertyIndex).getMinWidth();
    }

    @Override
    public int getMaxColumnWidth(int propertyIndex) {
        return this.getPropertyColumn(propertyIndex).getMaxWidth();
    }

    @Override
    public boolean isResizable(int propertyIndex) {
        return this.getPropertyColumn(propertyIndex).isResizable();
    }

    @Override
    public boolean isVisible(int propertyIndex) {
        return this.getPropertyColumn(propertyIndex).isVisible();
    }

    @Override
    public TableCellRenderer getColumnRenderer(int propertyIndex) {
        return this.getPropertyColumn(propertyIndex).getRenderer();
    }

    @Override
    public TableCellEditor getColumnEditor(int propertyIndex) {
        return this.getPropertyColumn(propertyIndex).getEditor();
    }

    @Override
    public boolean isSelectColumn(int propertyIndex) {
        return this.getPropertyColumn(propertyIndex).isSelectColumn();
    }

    @Override
    public Comparator getColumnComparator(int propertyIndex) {
        return this.getPropertyColumn(propertyIndex).getComparator();
    }
}

