/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.FormatStringValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.springframework.richclient.util.RcpSupport;

public class TableCellRenderers {
    public static final TableCellRenderer CENTER_ALIGNED_RENDERER = new AlignedRenderer(0);
    public static final TableCellRenderer RIGHT_ALIGNED_RENDERER = new AlignedRenderer(4);
    public static final TableCellRenderer TOP_ALIGNED_RENDERER = new AlignedRenderer(2, 1);
    public static final TableCellRenderer BOTTOM_ALIGNED_RENDERER = new AlignedRenderer(2, 3);
    public static final TableCellRenderer PERCENTAGE_RENDERER = new PercentageRenderer();
    public static final TableCellRenderer MONEY_RENDERER = new BigDecimalRenderer(NumberFormat.getCurrencyInstance(Locale.getDefault()));
    public static final TableCellRenderer LEFT_ALIGNED_HEADER_RENDERER = new AlignedTableHeaderRenderer(2);
    public static final TableCellRenderer CENTER_ALIGNED_HEADER_RENDERER = new AlignedTableHeaderRenderer(0);
    public static final TableCellRenderer RIGHT_ALIGNED_HEADER_RENDERER = new AlignedTableHeaderRenderer(4);
    public static final TableCellRenderer ENUM_RENDERER = new EnumTableCellRenderer();
    public static final TableCellRenderer FLAT_NUMBER_RENDERER = new FlatNumberRenderer();

    public static class ListPropertyCellRenderer
    extends JPanel
    implements TableCellRenderer {
        protected String property;
        protected int verticalAlignment;
        protected int horizontalAlignment;
        protected Format format;
        protected float alignmentX;
        private static Border border = new EmptyBorder(1, 2, 1, 2);

        public ListPropertyCellRenderer(String property) {
            this(property, 2, 0);
        }

        public ListPropertyCellRenderer(String property, int horizontalAlignment, int verticalAlignment) {
            this(property, horizontalAlignment, verticalAlignment, null);
        }

        public ListPropertyCellRenderer(String property, int horizontalAlignment, int verticalAlignment, Format format) {
            this.property = property;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.format = format;
            switch (horizontalAlignment) {
                case 2: {
                    this.alignmentX = 0.0f;
                    break;
                }
                case 0: {
                    this.alignmentX = 0.5f;
                    break;
                }
                case 4: {
                    this.alignmentX = 1.0f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal horizontal alignment value");
                }
            }
            this.setLayout(new BoxLayout(this, 1));
            this.setOpaque(true);
            this.setBorder(border);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.removeAll();
            this.invalidate();
            Color fg = table.getForeground();
            Color bg = table.getBackground();
            if (isSelected) {
                fg = table.getSelectionForeground();
                bg = table.getSelectionBackground();
            }
            Font font = table.getFont();
            this.setFont(font);
            if (hasFocus) {
                Border border = null;
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                this.setBorder(border);
                if (!isSelected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        fg = col;
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        bg = col;
                    }
                }
            } else {
                this.setBorder(border);
            }
            super.setForeground(fg);
            super.setBackground(bg);
            if (this.verticalAlignment != 1) {
                this.add(Box.createVerticalGlue());
            }
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException("Value must be an instance of Collection.");
            }
            Object[] values = ((Collection)value).toArray();
            for (int i = 0; i < values.length; ++i) {
                Object line;
                Object o = values[i];
                try {
                    line = PropertyUtils.getProperty((Object)o, (String)this.property);
                }
                catch (NestedNullException e) {
                    line = null;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error reading property " + this.property + " from object " + o, e);
                }
                JLabel lineLabel = new JLabel();
                lineLabel.setForeground(fg);
                lineLabel.setFont(font);
                this.setValue(lineLabel, line, i);
                this.add(lineLabel);
            }
            int height_wanted = (int)this.getPreferredSize().getHeight();
            if (height_wanted > table.getRowHeight(row)) {
                table.setRowHeight(row, height_wanted);
            }
            if (this.verticalAlignment != 3) {
                this.add(Box.createVerticalGlue());
            }
            return this;
        }

        protected void setValue(JLabel l, Object value, int lineNumber) {
            if (this.format != null && value != null) {
                value = this.format.format(value);
            }
            l.setText(value == null ? " " : value.toString());
            l.setHorizontalAlignment(this.horizontalAlignment);
            l.setAlignmentX(this.alignmentX);
            l.setOpaque(false);
        }
    }

    public static class EnumTableCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                this.setValue("");
                this.setIcon(null);
            } else if (value instanceof Enum) {
                Enum valueEnum = (Enum)value;
                Class<?> valueClass = valueEnum.getClass();
                this.setValue(RcpSupport.getMessage(valueClass.getName() + "." + valueEnum.name()));
                this.setIcon(RcpSupport.getIcon(valueClass.getName() + "." + valueEnum.name()));
            } else {
                this.setValue(value);
            }
            return this;
        }
    }

    public static class AlignedTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private int align = 0;

        public AlignedTableHeaderRenderer(int align) {
            this.align = align;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this.setText(value == null ? "" : value.toString() + " ");
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(this.align);
            return this;
        }
    }

    public static class BigDecimalRenderer
    extends DefaultTableCellRenderer {
        private final BigDecimal multiplyFactor;
        private final Format format;

        public BigDecimalRenderer(Format format) {
            this(null, format);
        }

        public BigDecimalRenderer(BigDecimal multiplyFactor) {
            this(multiplyFactor, NumberFormat.getNumberInstance());
        }

        public BigDecimalRenderer(BigDecimal multiplyFactor, Format format) {
            this(multiplyFactor, format, 4);
        }

        public BigDecimalRenderer(BigDecimal multiplyFactor, Format format, int horizontalAlignment) {
            this.multiplyFactor = multiplyFactor;
            this.format = format;
            this.setHorizontalAlignment(horizontalAlignment);
        }

        protected void setValue(Object value) {
            if (value instanceof BigDecimal) {
                if (this.multiplyFactor != null) {
                    value = ((BigDecimal)value).multiply(this.multiplyFactor);
                }
                super.setValue(this.format.format(value));
            } else {
                super.setValue(value);
            }
        }
    }

    public static class PercentageRenderer
    extends DefaultTableCellRenderer {
        private static final DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault());
        private static final Format nonFractionalFormat = new DecimalFormat("###     %", symbols);
        private static final Format fractionalFormat = new DecimalFormat("##0.00%", symbols);
        private static final BigDecimal multiplyFactor = new BigDecimal("100");

        public PercentageRenderer() {
            this.setHorizontalAlignment(4);
        }

        protected void setValue(Object value) {
            if (value instanceof BigDecimal) {
                BigDecimal percentage = ((BigDecimal)value).multiply(multiplyFactor);
                if (percentage.doubleValue() == (double)percentage.intValue()) {
                    super.setValue(nonFractionalFormat.format(value));
                } else {
                    super.setValue(fractionalFormat.format(value));
                }
            } else {
                super.setValue(value);
            }
        }
    }

    public static class AlignedRenderer
    extends DefaultTableCellRenderer {
        DateFormat formatter;

        public AlignedRenderer(int horizontalAlignment) {
            this.setHorizontalAlignment(horizontalAlignment);
        }

        public AlignedRenderer(int horizontalAlignment, int verticalAlignment) {
            this.setHorizontalAlignment(horizontalAlignment);
            this.setVerticalAlignment(verticalAlignment);
        }

        public void setValue(Object value) {
            if (value != null && value instanceof Date) {
                if (this.formatter == null) {
                    this.formatter = DateFormat.getDateInstance();
                }
                this.setText(this.formatter.format(value));
            } else {
                super.setValue(value);
            }
        }
    }

    public static class FlatNumberRenderer
    extends DefaultTableRenderer {
        private static NumberFormat format = NumberFormat.getIntegerInstance();

        public FlatNumberRenderer() {
            super((StringValue)new FormatStringValue((Format)format));
        }

        static {
            format.setGroupingUsed(false);
        }
    }
}

