/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget.table.glazedlists;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.EventJXTableModel;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.xswingx.JXSearchField;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.command.config.CommandConfigurer;
import org.springframework.richclient.util.RcpSupport;
import org.springframework.richclient.util.ValueMonitor;
import org.springframework.richclient.widget.AbstractWidget;
import org.springframework.richclient.widget.table.TableCellRenderers;
import org.springframework.richclient.widget.table.TableDescription;
import org.springframework.richclient.widget.table.TableWidget;
import org.springframework.richclient.widget.table.glazedlists.GlazedListsSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlazedListTableWidget
extends AbstractWidget
implements TableWidget {
    private JXTable theTable = new JXTable();
    private JScrollPane tableScroller;
    private ValueMonitor selectionMonitor = new ValueMonitor();
    private EventTableModel<Object> tableModel;
    private EventSelectionModel<Object> selectionModel;
    private EventList<Object> dataList;
    private EventList<Object> shownList;
    private SortedList<Object> sortedList;
    private JTextField textFilterField;
    private AbstractCommand[] navigationCommands;
    private CommandGroup navigationCommandGroup;
    private CommandGroup selectColumnCommandGroup;
    private CommandConfigurer commandConfigurer;
    private JLabel countLabel;
    private CellEditorListener userSelectionCellEditorListener = new CellEditorListener(){

        public void editingStopped(ChangeEvent e) {
            GlazedListTableWidget.this.fireUserSelectionChangedEvent();
        }

        public void editingCanceled(ChangeEvent e) {
        }
    };
    private Set dirtyRows = new HashSet();
    private CellEditorListener dirtyRowCellEditorListener = new CellEditorListener(){

        public void editingCanceled(ChangeEvent e) {
        }

        public void editingStopped(ChangeEvent e) {
            GlazedListTableWidget.this.dirtyRows.add(GlazedListTableWidget.this.getSelectedRows()[0]);
        }
    };
    private List<PropertyChangeListener> userSelectionListeners;
    public static final HighlightPredicate HIGHLIGHTSELECTCOLUMN;
    private TableComparatorChooser tableComparatorChooser;

    public GlazedListTableWidget(List<? extends Object> rows, TableDescription tableDesc) {
        this(rows, tableDesc, tableDesc.getDefaultComparator());
    }

    public GlazedListTableWidget(List<? extends Object> rows, TableDescription tableDesc, Comparator comparator) {
        this(tableDesc.getDataType(), rows, GlazedListsSupport.makeTableFormat(tableDesc), GlazedListsSupport.makeFilterProperties(tableDesc), comparator, tableDesc.hasSelectColumn());
        TableCellEditor columnEditor = null;
        block4: for (int i = 0; i < tableDesc.getColumnCount(); ++i) {
            TableColumnExt column = (TableColumnExt)this.theTable.getColumns(true).get(i);
            int columnWidth = tableDesc.getMaxColumnWidth(i);
            if (columnWidth > 0) {
                column.setMaxWidth(columnWidth);
            }
            if ((columnWidth = tableDesc.getMinColumnWidth(i)) > 0) {
                column.setMinWidth(columnWidth);
            }
            column.setResizable(tableDesc.isResizable(i));
            column.setVisible(tableDesc.isVisible(i));
            columnEditor = tableDesc.getColumnEditor(i);
            if (columnEditor != null) {
                if (tableDesc.isSelectColumn(i)) {
                    columnEditor.addCellEditorListener(this.userSelectionCellEditorListener);
                } else {
                    columnEditor.addCellEditorListener(this.dirtyRowCellEditorListener);
                }
                column.setCellEditor(columnEditor);
            }
            if (tableDesc.getColumnRenderer(i) == null) continue;
            TableCellRenderer renderer = tableDesc.getColumnRenderer(i);
            column.setCellRenderer(renderer);
            if (!(renderer instanceof DefaultTableCellRenderer)) continue;
            int align = ((DefaultTableCellRenderer)renderer).getHorizontalAlignment();
            switch (align) {
                case 0: {
                    column.setHeaderRenderer(this.wrapInSortArrowHeaderRenderer(TableCellRenderers.CENTER_ALIGNED_HEADER_RENDERER));
                    continue block4;
                }
                case 4: {
                    column.setHeaderRenderer(this.wrapInSortArrowHeaderRenderer(TableCellRenderers.RIGHT_ALIGNED_HEADER_RENDERER));
                    continue block4;
                }
            }
        }
    }

    private TableCellRenderer wrapInSortArrowHeaderRenderer(TableCellRenderer renderer) {
        if (this.tableComparatorChooser != null) {
            return this.tableComparatorChooser.createSortArrowHeaderRenderer(renderer);
        }
        return renderer;
    }

    public GlazedListTableWidget(Class dataType, List<? extends Object> rows, TableFormat format, String[] filterProperties) {
        this(dataType, rows, format, filterProperties, null, false);
    }

    public GlazedListTableWidget(Class dataType, List<? extends Object> rows, TableFormat format, String[] filterProperties, Comparator comparator, boolean addHighlightSelectColumn) {
        this.theTable.setColumnControlVisible(true);
        this.theTable.getSelectionMapper().setEnabled(false);
        this.commandConfigurer = (CommandConfigurer)Application.services().getService(CommandConfigurer.class);
        this.dataList = rows == null ? new BasicEventList() : GlazedLists.eventList(rows);
        this.sortedList = new SortedList(this.dataList, comparator);
        this.shownList = this.sortedList;
        if (filterProperties != null) {
            this.textFilterField = new JXSearchField(RcpSupport.getMessage("glazedListTableWidget.textFilterField.prompt"));
            this.textFilterField.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    GlazedListTableWidget.this.textFilterField.selectAll();
                }
            });
            this.shownList = new FilterList(this.shownList, (MatcherEditor)new TextComponentMatcherEditor((JTextComponent)this.textFilterField, GlazedLists.textFilterator((Class)dataType, (String[])filterProperties)));
        }
        this.selectionModel = new EventSelectionModel(this.shownList);
        this.selectionModel.addListSelectionListener((ListSelectionListener)new SelectionNavigationListener());
        this.theTable.setSelectionModel(this.selectionModel);
        this.tableModel = new EventJXTableModel(this.shownList, format);
        this.theTable.setModel(this.tableModel);
        if (addHighlightSelectColumn) {
            ColorHighlighter selectHighlighter = new ColorHighlighter(HIGHLIGHTSELECTCOLUMN, new Color(240, 240, 224), Color.BLACK);
            this.setHighlighters(new Highlighter[]{HighlighterFactory.createSimpleStriping(), selectHighlighter});
            this.initializeSelectColumnCommands();
        } else {
            this.setHighlighters(HighlighterFactory.createSimpleStriping());
        }
        if (this.sortedList != null) {
            this.theTable.setSortable(false);
            this.theTable.getTableHeader().setDefaultRenderer(TableCellRenderers.LEFT_ALIGNED_HEADER_RENDERER);
            this.tableComparatorChooser = TableComparatorChooser.install((JTable)this.theTable, this.sortedList, (Object)TableComparatorChooser.MULTIPLE_COLUMN_MOUSE_WITH_UNDO);
            this.tableComparatorChooser.addSortActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EventList selected = GlazedListTableWidget.this.selectionModel.getSelected();
                    int[] indexes = new int[selected.size()];
                    int i = 0;
                    for (Object o : selected) {
                        indexes[i++] = GlazedListTableWidget.this.shownList.indexOf(o);
                    }
                    GlazedListTableWidget.this.selectionModel.clearSelection();
                    for (int index : indexes) {
                        GlazedListTableWidget.this.selectionModel.addSelectionInterval(index, index);
                    }
                }
            });
        }
        this.theTable.setPreferredScrollableViewportSize(new Dimension(50, 50));
        this.tableScroller = new JScrollPane((Component)this.theTable);
        this.theTable.setHorizontalScrollEnabled(true);
        this.initializeNavigationCommands();
    }

    public void setRowHeightEnabled(boolean rowHeightEnabled) {
        this.theTable.setRowHeightEnabled(true);
    }

    public void setHighlighters(Highlighter ... highlighters) {
        this.theTable.setHighlighters(highlighters);
    }

    @Override
    public boolean isEmpty() {
        return this.dataList.isEmpty();
    }

    @Override
    public int nrOfRows() {
        return this.tableModel.getRowCount();
    }

    private void initializeNavigationCommands() {
        this.navigationCommands = new AbstractCommand[4];
        this.navigationCommands[0] = new ActionCommand("firstrow"){

            protected void doExecuteCommand() {
                GlazedListTableWidget.this.selectionModel.setSelectionInterval(0, 0);
                GlazedListTableWidget.this.scrollToSelectedRow();
            }
        };
        this.navigationCommands[1] = new ActionCommand("previousrow"){

            protected void doExecuteCommand() {
                int newIndex = GlazedListTableWidget.this.selectionModel.getAnchorSelectionIndex() - 1;
                newIndex = newIndex < 0 ? 0 : newIndex;
                GlazedListTableWidget.this.selectionModel.setSelectionInterval(newIndex, newIndex);
                GlazedListTableWidget.this.scrollToSelectedRow();
            }
        };
        this.navigationCommands[2] = new ActionCommand("nextrow"){

            protected void doExecuteCommand() {
                int lastIndex;
                int newIndex = GlazedListTableWidget.this.selectionModel.getAnchorSelectionIndex() + 1;
                newIndex = newIndex > (lastIndex = GlazedListTableWidget.this.shownList.size() - 1) ? lastIndex : newIndex;
                GlazedListTableWidget.this.selectionModel.setSelectionInterval(newIndex, newIndex);
                GlazedListTableWidget.this.scrollToSelectedRow();
            }
        };
        this.navigationCommands[3] = new ActionCommand("lastrow"){

            protected void doExecuteCommand() {
                int lastIndex = GlazedListTableWidget.this.shownList.size() - 1;
                GlazedListTableWidget.this.selectionModel.setSelectionInterval(lastIndex, lastIndex);
                GlazedListTableWidget.this.scrollToSelectedRow();
            }
        };
        for (int i = 0; i < this.navigationCommands.length; ++i) {
            this.commandConfigurer.configure(this.navigationCommands[i]);
            this.navigationCommands[i].setEnabled(false);
        }
        this.navigationCommandGroup = CommandGroup.createCommandGroup(this.navigationCommands);
    }

    private void fireUserSelectionChangedEvent() {
        if (this.userSelectionListeners != null) {
            for (PropertyChangeListener listener : this.userSelectionListeners) {
                listener.propertyChange(new PropertyChangeEvent(this, "selection", null, null));
            }
        }
    }

    public void addUserSelectionListener(PropertyChangeListener listener) {
        if (this.userSelectionListeners == null) {
            this.userSelectionListeners = new ArrayList<PropertyChangeListener>();
        }
        this.userSelectionListeners.add(listener);
    }

    private void initializeSelectColumnCommands() {
        final WritableTableFormat writableTableFormat = (WritableTableFormat)this.tableModel.getTableFormat();
        ActionCommand selectAll = new ActionCommand("select.all"){

            protected void doExecuteCommand() {
                GlazedListTableWidget.this.shownList.getReadWriteLock().writeLock().lock();
                Iterator i = GlazedListTableWidget.this.shownList.iterator();
                while (i.hasNext()) {
                    writableTableFormat.setColumnValue(i.next(), (Object)Boolean.TRUE, 0);
                }
                GlazedListTableWidget.this.shownList.getReadWriteLock().writeLock().unlock();
                GlazedListTableWidget.this.theTable.repaint();
                GlazedListTableWidget.this.fireUserSelectionChangedEvent();
            }
        };
        this.commandConfigurer.configure(selectAll);
        ActionCommand selectNone = new ActionCommand("select.none"){

            protected void doExecuteCommand() {
                GlazedListTableWidget.this.shownList.getReadWriteLock().writeLock().lock();
                Iterator i = GlazedListTableWidget.this.shownList.iterator();
                while (i.hasNext()) {
                    writableTableFormat.setColumnValue(i.next(), (Object)Boolean.FALSE, 0);
                }
                GlazedListTableWidget.this.shownList.getReadWriteLock().writeLock().unlock();
                GlazedListTableWidget.this.theTable.repaint();
                GlazedListTableWidget.this.fireUserSelectionChangedEvent();
            }
        };
        this.commandConfigurer.configure(selectNone);
        ActionCommand selectInverse = new ActionCommand("select.inverse"){

            protected void doExecuteCommand() {
                GlazedListTableWidget.this.shownList.getReadWriteLock().writeLock().lock();
                Iterator i = GlazedListTableWidget.this.shownList.iterator();
                while (i.hasNext()) {
                    Object rowObject;
                    Object columnValue = writableTableFormat.getColumnValue(rowObject = i.next(), 0);
                    writableTableFormat.setColumnValue(rowObject, (Object)(Boolean.TRUE.equals(columnValue) ? Boolean.FALSE : Boolean.TRUE), 0);
                }
                GlazedListTableWidget.this.shownList.getReadWriteLock().writeLock().unlock();
                GlazedListTableWidget.this.theTable.repaint();
                GlazedListTableWidget.this.fireUserSelectionChangedEvent();
            }
        };
        this.commandConfigurer.configure(selectInverse);
        this.selectColumnCommandGroup = CommandGroup.createCommandGroup(new Object[]{selectAll, selectNone, selectInverse});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRows(Collection newRows) {
        this.dataList.getReadWriteLock().writeLock().lock();
        try {
            this.dirtyRows.clear();
            this.theTable.clearSelection();
            this.dataList.clear();
            this.dataList.addAll(newRows);
            this.scrollToSelectedRow();
        }
        finally {
            this.dataList.getReadWriteLock().writeLock().unlock();
        }
    }

    public final List getRows() {
        return new ArrayList<Object>((Collection<Object>)this.dataList);
    }

    public final List getVisibleRows() {
        return new ArrayList<Object>((Collection<Object>)this.shownList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRowObject(Object newObject) {
        this.dataList.getReadWriteLock().writeLock().lock();
        try {
            this.dataList.add(newObject);
        }
        finally {
            this.dataList.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRows(Collection rows) {
        this.dataList.getReadWriteLock().writeLock().lock();
        try {
            this.dataList.addAll(rows);
        }
        finally {
            this.dataList.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRowObject(Object objectToRemove) {
        this.dataList.getReadWriteLock().writeLock().lock();
        try {
            this.dirtyRows.remove(objectToRemove);
            this.dataList.remove(objectToRemove);
        }
        finally {
            this.dataList.getReadWriteLock().writeLock().unlock();
        }
    }

    public int selectRowObject(Object toPointTo, Observer originatingObserver) {
        int index = this.shownList.indexOf(toPointTo);
        this.selectRowObject(index, originatingObserver);
        return index;
    }

    @Override
    public void selectRowObject(final int index, final Observer originatingObserver) {
        Runnable doSelectRowObject = new Runnable(){

            public void run() {
                if (originatingObserver != null) {
                    GlazedListTableWidget.this.selectionMonitor.deleteObserver(originatingObserver);
                }
                if (index > -1 && GlazedListTableWidget.this.shownList.size() > index) {
                    GlazedListTableWidget.this.selectionModel.setSelectionInterval(index, index);
                } else {
                    GlazedListTableWidget.this.selectionModel.clearSelection();
                }
                GlazedListTableWidget.this.scrollToSelectedRow();
                if (originatingObserver != null) {
                    GlazedListTableWidget.this.selectionMonitor.addObserver(originatingObserver);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doSelectRowObject.run();
        } else {
            SwingUtilities.invokeLater(doSelectRowObject);
        }
    }

    public void addSelection(final Object[] rows, final Observer originatingObserver) {
        Runnable doAddSelection = new Runnable(){

            public void run() {
                if (originatingObserver != null) {
                    GlazedListTableWidget.this.selectionMonitor.deleteObserver(originatingObserver);
                }
                for (int i = 0; i < rows.length; ++i) {
                    int index = GlazedListTableWidget.this.shownList.indexOf(rows[i]);
                    GlazedListTableWidget.this.selectionModel.addSelectionInterval(index, index);
                }
                if (originatingObserver != null) {
                    GlazedListTableWidget.this.selectionMonitor.addObserver(originatingObserver);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doAddSelection.run();
        } else {
            SwingUtilities.invokeLater(doAddSelection);
        }
    }

    @Override
    public boolean hasSelection() {
        return !this.selectionModel.isSelectionEmpty();
    }

    public synchronized void scrollToSelectedRow() {
        Runnable doScrollToSelectedRow = new Runnable(){

            public void run() {
                if (GlazedListTableWidget.this.theTable.isVisible()) {
                    int selectedRow = GlazedListTableWidget.this.theTable.getSelectedRow();
                    if (selectedRow != -1) {
                        Rectangle cellRect = GlazedListTableWidget.this.theTable.getCellRect(selectedRow, 0, true);
                        Rectangle viewRect = GlazedListTableWidget.this.tableScroller.getViewport().getViewRect();
                        if (!viewRect.contains(cellRect)) {
                            if (cellRect.y < viewRect.y) {
                                GlazedListTableWidget.this.tableScroller.getViewport().setViewPosition(cellRect.getLocation());
                            } else {
                                GlazedListTableWidget.this.tableScroller.getViewport().scrollRectToVisible(cellRect);
                            }
                        }
                    } else {
                        GlazedListTableWidget.this.tableScroller.getViewport().setViewPosition(new Point(0, 0));
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doScrollToSelectedRow.run();
        } else {
            SwingUtilities.invokeLater(doScrollToSelectedRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceRowObject(Object oldObject, Object newObject, Observer originatingObserver) {
        this.dataList.getReadWriteLock().writeLock().lock();
        try {
            this.dirtyRows.remove(oldObject);
            int index = this.dataList.indexOf(oldObject);
            if (index != -1) {
                boolean wasSelected = this.selectionModel.isSelectedIndex(this.shownList.indexOf(oldObject));
                if (wasSelected && originatingObserver != null) {
                    this.selectionMonitor.deleteObserver(originatingObserver);
                }
                this.dataList.set(index, newObject);
                if (wasSelected) {
                    int indexToSelect = this.shownList.indexOf(newObject);
                    this.selectionModel.addSelectionInterval(indexToSelect, indexToSelect);
                    if (originatingObserver != null) {
                        this.selectionMonitor.addObserver(originatingObserver);
                    }
                }
            }
        }
        finally {
            this.dataList.getReadWriteLock().writeLock().unlock();
        }
    }

    public void replaceRows(final Collection oldObject, final Collection newObject) {
        Runnable doReplaceRows = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GlazedListTableWidget.this.dataList.getReadWriteLock().writeLock().lock();
                try {
                    GlazedListTableWidget.this.dirtyRows.clear();
                    GlazedListTableWidget.this.dataList.removeAll(oldObject);
                    GlazedListTableWidget.this.dataList.addAll(newObject);
                }
                finally {
                    GlazedListTableWidget.this.dataList.getReadWriteLock().writeLock().unlock();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doReplaceRows.run();
        } else {
            SwingUtilities.invokeLater(doReplaceRows);
        }
    }

    @Override
    public void unSelectAll() {
        Runnable doUnselectAll = new Runnable(){

            public void run() {
                GlazedListTableWidget.this.selectionModel.clearSelection();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doUnselectAll.run();
        } else {
            SwingUtilities.invokeLater(doUnselectAll);
        }
    }

    @Override
    public Object[] getSelectedRows() {
        return this.selectionModel.getSelected().toArray();
    }

    @Override
    public JComponent getComponent() {
        return this.tableScroller;
    }

    @Override
    public JTable getTable() {
        return this.theTable;
    }

    @Override
    public void addSelectionObserver(Observer observer) {
        this.selectionMonitor.addObserver(observer);
    }

    @Override
    public void removeSelectionObserver(Observer observer) {
        this.selectionMonitor.deleteObserver(observer);
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this.tableModel.addTableModelListener(listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.tableModel.removeTableModelListener(listener);
    }

    @Override
    public void updateTable() {
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public JTextField getTextFilterField() {
        return this.textFilterField;
    }

    @Override
    public AbstractCommand[] getNavigationCommands() {
        return this.navigationCommands;
    }

    @Override
    public JComponent getNavigationButtonBar() {
        return this.getNavigationButtonBar((Size)Sizes.PREFERRED, BorderFactory.createEmptyBorder());
    }

    public JComponent getNavigationButtonBar(Size size, Border border) {
        return this.navigationCommandGroup.createButtonBar(size, border);
    }

    public CommandGroup getNavigationCommandGroup() {
        return this.navigationCommandGroup;
    }

    public CommandGroup getSelectColumnCommandGroup() {
        return this.selectColumnCommandGroup;
    }

    @Override
    public JComponent getSelectButtonBar() {
        return this.selectColumnCommandGroup.createButtonBar((Size)Sizes.PREFERRED, BorderFactory.createEmptyBorder());
    }

    @Override
    public JComponent getButtonBar() {
        if (this.selectColumnCommandGroup != null) {
            JPanel buttons = new JPanel((LayoutManager)new FormLayout("fill:pref, 3dlu, fill:pref, 3dlu, fill:pref", "fill:pref:grow"));
            CellConstraints cc = new CellConstraints();
            buttons.add((Component)this.getSelectButtonBar(), cc.xy(1, 1));
            buttons.add((Component)new JSeparator(1), cc.xy(3, 1));
            buttons.add((Component)this.getNavigationButtonBar(), cc.xy(5, 1));
            return buttons;
        }
        return this.getNavigationButtonBar();
    }

    @Override
    public JLabel getListSummaryLabel() {
        if (this.countLabel == null) {
            this.countLabel = this.createCountLabel();
        }
        return this.countLabel;
    }

    private JLabel createCountLabel() {
        final JLabel label = new JLabel("");
        this.setTextForListSummaryLabel(label);
        this.shownList.addListEventListener((ListEventListener)new ListEventListener<Object>(){

            public void listChanged(ListEvent<Object> evt) {
                if (!evt.isReordering()) {
                    GlazedListTableWidget.this.setTextForListSummaryLabel(label);
                }
            }
        });
        this.theTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    GlazedListTableWidget.this.setTextForListSummaryLabel(label);
                }
            }
        });
        return label;
    }

    private void setTextForListSummaryLabel(final JLabel label) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Integer index = 0;
                Integer selectedCount = 0;
                Integer totalCount = GlazedListTableWidget.this.shownList.size();
                if (GlazedListTableWidget.this.getSelectedRows() != null && GlazedListTableWidget.this.getSelectedRows().length > 0) {
                    Integer n = index = Integer.valueOf(GlazedListTableWidget.this.shownList.indexOf(GlazedListTableWidget.this.getSelectedRows()[0]));
                    Integer n2 = index = Integer.valueOf(index + 1);
                    selectedCount = GlazedListTableWidget.this.getSelectedRows().length;
                }
                label.setText(RcpSupport.getMessage("glazedListTableWidget", "listSummary", "label", new Object[]{index, selectedCount, totalCount}));
            }
        });
    }

    @Override
    public void onAboutToShow() {
        super.onAboutToShow();
        this.theTable.requestFocusInWindow();
    }

    public Set getDirtyRows() {
        return this.dirtyRows;
    }

    static {
        UIManager.put("JXTable.column.horizontalScroll", RcpSupport.getMessage("JXTable.horizontalScroll.label"));
        UIManager.put("JXTable.column.packAll", RcpSupport.getMessage("JXTable.packAll.label"));
        UIManager.put("JXTable.column.packSelected", RcpSupport.getMessage("JXTable.packSelected.label"));
        HIGHLIGHTSELECTCOLUMN = new HighlightSelectColumn();
    }

    static class HighlightSelectColumn
    implements HighlightPredicate {
        HighlightSelectColumn() {
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            Object selectedValue = adapter.getValueAt(adapter.row, 0);
            return Boolean.TRUE.equals(selectedValue);
        }
    }

    private class SelectionNavigationListener
    implements ListSelectionListener {
        private SelectionNavigationListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (GlazedListTableWidget.this.selectionModel.getSelected().size() == 1) {
                    GlazedListTableWidget.this.selectionMonitor.setValue(GlazedListTableWidget.this.selectionModel.getSelected().get(0));
                } else {
                    Object[] selectedRows = GlazedListTableWidget.this.selectionModel.getSelected().toArray();
                    GlazedListTableWidget.this.selectionMonitor.setValue(selectedRows.length > 0 ? selectedRows : null);
                }
                int selectedIndex = GlazedListTableWidget.this.selectionModel.getAnchorSelectionIndex();
                int lastIndex = GlazedListTableWidget.this.shownList.size() - 1;
                boolean emptyList = lastIndex == -1;
                boolean onFirst = selectedIndex == 0;
                boolean onLast = selectedIndex == lastIndex;
                GlazedListTableWidget.this.navigationCommands[0].setEnabled(!emptyList && !onFirst);
                GlazedListTableWidget.this.navigationCommands[1].setEnabled(!emptyList && !onFirst);
                GlazedListTableWidget.this.navigationCommands[2].setEnabled(!emptyList && !onLast);
                GlazedListTableWidget.this.navigationCommands[3].setEnabled(!emptyList && !onLast);
            }
        }
    }
}

